/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.block.paint.PaintSplotchesModel;
import appeng.block.qnb.QnbFormedModel;
import appeng.bootstrap.components.IClientSetupComponent;
import appeng.bootstrap.components.IInitComponent;
import appeng.bootstrap.components.IPostInitComponent;
import appeng.capabilities.Capabilities;
import appeng.client.ClientHelper;
import appeng.client.render.DummyFluidItemModel;
import appeng.client.render.FacadeItemModel;
import appeng.client.render.SimpleModelLoader;
import appeng.client.render.cablebus.CableBusModelLoader;
import appeng.client.render.cablebus.P2PTunnelFrequencyModel;
import appeng.client.render.crafting.CraftingCubeModelLoader;
import appeng.client.render.crafting.EncodedPatternModelLoader;
import appeng.client.render.model.BiometricCardModel;
import appeng.client.render.model.ColorApplicatorModel;
import appeng.client.render.model.DriveModel;
import appeng.client.render.model.GlassModel;
import appeng.client.render.model.MemoryCardModel;
import appeng.client.render.model.SkyCompassModel;
import appeng.client.render.model.UVLModelLoader;
import appeng.client.render.spatial.SpatialPylonModel;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AddonLoader;
import appeng.core.Api;
import appeng.core.ApiDefinitions;
import appeng.core.CommonHelper;
import appeng.core.CreativeTab;
import appeng.core.FacadeItemGroup;
import appeng.core.Registration;
import appeng.core.crash.ModCrashEnhancement;
import appeng.core.features.registries.PartModels;
import appeng.core.stats.AdvancementTriggers;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.worlddata.WorldData;
import appeng.entity.ChargedQuartzEntity;
import appeng.entity.GrowingCrystalEntity;
import appeng.entity.SingularityEntity;
import appeng.entity.TinyTNTPrimedEntity;
import appeng.entity.TinyTNTPrimedRenderer;
import appeng.hooks.TickHandler;
import appeng.integration.Integrations;
import appeng.parts.PartPlacement;
import appeng.parts.automation.PlaneModelLoader;
import appeng.server.ServerHelper;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.CrashReportExtender;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="appliedenergistics2")
public final class AppEng {
    public static CommonHelper proxy;
    public static final String MOD_ID = "appliedenergistics2";
    public static final String MOD_NAME = "Applied Energistics 2";
    private static AppEng INSTANCE;
    private final Registration registration;

    public AppEng() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, AEConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, AEConfig.COMMON_SPEC);
        proxy = (CommonHelper)DistExecutor.runForDist(() -> ClientHelper::new, () -> ServerHelper::new);
        CrashReportExtender.registerCrashCallable((ICrashCallable)new ModCrashEnhancement());
        CreativeTab.init();
        new FacadeItemGroup();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        this.registration = new Registration();
        modEventBus.addGenericListener(Block.class, this.registration::registerBlocks);
        modEventBus.addGenericListener(Item.class, this.registration::registerItems);
        modEventBus.addGenericListener(EntityType.class, this.registration::registerEntities);
        modEventBus.addGenericListener(ParticleType.class, this.registration::registerParticleTypes);
        modEventBus.addGenericListener(TileEntityType.class, this.registration::registerTileEntities);
        modEventBus.addGenericListener(ContainerType.class, this.registration::registerContainerTypes);
        modEventBus.addGenericListener(IRecipeSerializer.class, this.registration::registerRecipeSerializers);
        modEventBus.addGenericListener(Feature.class, this.registration::registerWorldGen);
        modEventBus.addGenericListener(Biome.class, this.registration::registerBiomes);
        modEventBus.addGenericListener(ModDimension.class, this.registration::registerModDimension);
        modEventBus.addListener(Integrations::enqueueIMC);
        modEventBus.addListener(this::commonSetup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this.registration::registerClientEvents);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(this::clientSetup));
        MinecraftForge.EVENT_BUS.addListener(TickHandler.INSTANCE::unloadWorld);
        MinecraftForge.EVENT_BUS.addListener(TickHandler.INSTANCE::onTick);
        MinecraftForge.EVENT_BUS.addListener(this::onServerAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
        MinecraftForge.EVENT_BUS.addListener(this.registration::registerCommands);
        MinecraftForge.EVENT_BUS.register((Object)new PartPlacement());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        definitions.getRegistry().getBootstrapComponents(IInitComponent.class).forEachRemaining(IInitComponent::initialize);
        definitions.getRegistry().getBootstrapComponents(IPostInitComponent.class).forEachRemaining(IPostInitComponent::postInitialize);
        Capabilities.register();
        Registration.setupInternalRegistries();
        Registration.postInit();
        this.registerNetworkHandler();
        AddonLoader.loadAddons(Api.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        ((ClientHelper)proxy).clientInit();
        RenderingRegistry.registerEntityRenderingHandler(TinyTNTPrimedEntity.TYPE, TinyTNTPrimedRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SingularityEntity.TYPE, m -> new ItemRenderer(m, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(GrowingCrystalEntity.TYPE, m -> new ItemRenderer(m, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ChargedQuartzEntity.TYPE, m -> new ItemRenderer(m, Minecraft.func_71410_x().func_175599_af()));
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        definitions.getRegistry().getBootstrapComponents(IClientSetupComponent.class).forEachRemaining(IClientSetupComponent::setup);
        AppEng.addBuiltInModel("glass", GlassModel::new);
        AppEng.addBuiltInModel("sky_compass", SkyCompassModel::new);
        AppEng.addBuiltInModel("dummy_fluid_item", DummyFluidItemModel::new);
        AppEng.addBuiltInModel("memory_card", MemoryCardModel::new);
        AppEng.addBuiltInModel("biometric_card", BiometricCardModel::new);
        AppEng.addBuiltInModel("drive", DriveModel::new);
        AppEng.addBuiltInModel("color_applicator", ColorApplicatorModel::new);
        AppEng.addBuiltInModel("spatial_pylon", SpatialPylonModel::new);
        AppEng.addBuiltInModel("paint_splotches", PaintSplotchesModel::new);
        AppEng.addBuiltInModel("quantum_bridge_formed", QnbFormedModel::new);
        AppEng.addBuiltInModel("p2p_tunnel_frequency", P2PTunnelFrequencyModel::new);
        AppEng.addBuiltInModel("facade", FacadeItemModel::new);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation(MOD_ID, "encoded_pattern"), (IModelLoader)EncodedPatternModelLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation(MOD_ID, "part_plane"), (IModelLoader)PlaneModelLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation(MOD_ID, "crafting_cube"), (IModelLoader)CraftingCubeModelLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation(MOD_ID, "uvlightmap"), (IModelLoader)UVLModelLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation(MOD_ID, "cable_bus"), (IModelLoader)new CableBusModelLoader((PartModels)Api.INSTANCE.registries().partModels()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static <T extends IModelGeometry<T>> void addBuiltInModel(String id, Supplier<T> modelFactory) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation(MOD_ID, id), new SimpleModelLoader<T>(modelFactory));
    }

    @Nonnull
    public static AppEng instance() {
        if (INSTANCE == null) {
            throw new IllegalStateException();
        }
        return INSTANCE;
    }

    public AdvancementTriggers getAdvancementTriggers() {
        return this.registration.advancementTriggers;
    }

    private void startService(String serviceName, Thread thread) {
        thread.setName(serviceName);
        thread.setPriority(1);
        AELog.info("Starting " + serviceName, new Object[0]);
        thread.start();
    }

    private void registerNetworkHandler() {
        Stopwatch start = Stopwatch.createStarted();
        AELog.info("Post Initialization ( started )", new Object[0]);
        proxy.postInit();
        AEConfig.instance().save();
        NetworkHandler.init(new ResourceLocation(MOD_ID, "main"));
        AELog.info("Post Initialization ( ended after " + start.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    private void onServerAboutToStart(FMLServerAboutToStartEvent evt) {
        WorldData.onServerStarting(evt.getServer());
    }

    private void serverStopping(FMLServerStoppingEvent event) {
        WorldData.instance().onServerStopping();
    }

    private void serverStopped(FMLServerStoppedEvent event) {
        WorldData.instance().onServerStoppped();
        TickHandler.INSTANCE.shutdown();
    }
}

