/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.api;

import appeng.api.client.ICellModelRegistry;
import appeng.api.client.IClientHelper;
import appeng.api.config.IncludeExclude;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.data.IAEStack;
import appeng.core.ApiDefinitions;
import appeng.core.api.client.ApiCellModelRegistry;
import appeng.core.localization.GuiText;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ApiClientHelper
implements IClientHelper {
    private final ICellModelRegistry cells;

    public ApiClientHelper(ApiDefinitions definitions) {
        this.cells = new ApiCellModelRegistry(definitions);
    }

    @Override
    public <T extends IAEStack<T>> void addCellInformation(ICellInventoryHandler<T> handler, List<ITextComponent> lines) {
        if (handler == null) {
            return;
        }
        ICellInventory<T> cellInventory = handler.getCellInv();
        if (cellInventory != null) {
            lines.add(new StringTextComponent(cellInventory.getUsedBytes() + " ").func_150257_a(GuiText.Of.textComponent()).func_150258_a(" " + cellInventory.getTotalBytes() + " ").func_150257_a(GuiText.BytesUsed.textComponent()));
            lines.add(new StringTextComponent(cellInventory.getStoredItemTypes() + " ").func_150257_a(GuiText.Of.textComponent()).func_150258_a(" " + cellInventory.getTotalItemTypes() + " ").func_150257_a(GuiText.Types.textComponent()));
        }
        if (handler.isPreformatted()) {
            String list = (handler.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
            if (handler.isFuzzy()) {
                lines.add(GuiText.Partitioned.textComponent().func_150258_a(" - " + list + " ").func_150257_a(GuiText.Fuzzy.textComponent()));
            } else {
                lines.add(GuiText.Partitioned.textComponent().func_150258_a(" - " + list + " ").func_150257_a(GuiText.Precise.textComponent()));
            }
        }
    }

    @Override
    public ICellModelRegistry cells() {
        return this.cells;
    }
}

