/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.api;

import appeng.api.config.Actionable;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageHelper;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.crafting.CraftingLink;
import appeng.fluids.items.FluidDummyItem;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.FluidList;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.item.ItemList;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class ApiStorage
implements IStorageHelper {
    private final ClassToInstanceMap<IStorageChannel<?>> channels = MutableClassToInstanceMap.create();

    public ApiStorage() {
        this.registerStorageChannel(IItemStorageChannel.class, new ItemStorageChannel());
        this.registerStorageChannel(IFluidStorageChannel.class, new FluidStorageChannel());
    }

    @Override
    public <T extends IAEStack<T>, C extends IStorageChannel<T>> void registerStorageChannel(Class<C> channel, C factory) {
        Preconditions.checkNotNull(channel);
        Preconditions.checkNotNull(factory);
        Preconditions.checkArgument((boolean)channel.isInstance(factory));
        Preconditions.checkArgument((!this.channels.containsKey(channel) ? 1 : 0) != 0);
        this.channels.putInstance(channel, factory);
    }

    @Override
    public <T extends IAEStack<T>, C extends IStorageChannel<T>> C getStorageChannel(Class<C> channel) {
        Preconditions.checkNotNull(channel);
        IStorageChannel type = (IStorageChannel)this.channels.getInstance(channel);
        Preconditions.checkNotNull((Object)type);
        return (C)type;
    }

    @Override
    public Collection<IStorageChannel<? extends IAEStack<?>>> storageChannels() {
        return Collections.unmodifiableCollection(this.channels.values());
    }

    @Override
    public ICraftingLink loadCraftingLink(CompoundNBT data, ICraftingRequester req) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)req);
        return new CraftingLink(data, req);
    }

    @Override
    public <T extends IAEStack<T>> T poweredInsert(IEnergySource energy, IMEInventory<T> inv, T input, IActionSource src, Actionable mode) {
        return Platform.poweredInsert(energy, inv, input, src, mode);
    }

    @Override
    public <T extends IAEStack<T>> T poweredExtraction(IEnergySource energy, IMEInventory<T> inv, T request, IActionSource src, Actionable mode) {
        return Platform.poweredExtraction(energy, inv, request, src, mode);
    }

    @Override
    public void postChanges(IStorageGrid gs, ItemStack removedCell, ItemStack addedCell, IActionSource src) {
        Preconditions.checkNotNull((Object)gs);
        Preconditions.checkNotNull((Object)removedCell);
        Preconditions.checkNotNull((Object)addedCell);
        Preconditions.checkNotNull((Object)src);
        Platform.postChanges(gs, removedCell, addedCell, src);
    }

    private static final class FluidStorageChannel
    implements IFluidStorageChannel {
        private FluidStorageChannel() {
        }

        @Override
        public int transferFactor() {
            return 125;
        }

        @Override
        public int getUnitsPerByte() {
            return 8000;
        }

        @Override
        public IItemList<IAEFluidStack> createList() {
            return new FluidList();
        }

        @Override
        public IAEFluidStack createStack(Object input) {
            Preconditions.checkNotNull((Object)input);
            if (input instanceof FluidStack) {
                return AEFluidStack.fromFluidStack((FluidStack)input);
            }
            if (input instanceof ItemStack) {
                ItemStack is = (ItemStack)input;
                if (is.func_77973_b() instanceof FluidDummyItem) {
                    return AEFluidStack.fromFluidStack(((FluidDummyItem)is.func_77973_b()).getFluidStack(is));
                }
                return AEFluidStack.fromFluidStack((FluidStack)FluidUtil.getFluidContained((ItemStack)is).orElse(null));
            }
            return null;
        }

        @Override
        public IAEFluidStack readFromPacket(PacketBuffer input) {
            Preconditions.checkNotNull((Object)input);
            return AEFluidStack.fromPacket(input);
        }

        @Override
        public IAEFluidStack createFromNBT(CompoundNBT nbt) {
            Preconditions.checkNotNull((Object)nbt);
            return AEFluidStack.fromNBT(nbt);
        }
    }

    private static final class ItemStorageChannel
    implements IItemStorageChannel {
        private ItemStorageChannel() {
        }

        @Override
        public IItemList<IAEItemStack> createList() {
            return new ItemList();
        }

        @Override
        public IAEItemStack createStack(Object input) {
            Preconditions.checkNotNull((Object)input);
            if (input instanceof ItemStack) {
                return AEItemStack.fromItemStack((ItemStack)input);
            }
            return null;
        }

        @Override
        public IAEItemStack createFromNBT(CompoundNBT nbt) {
            Preconditions.checkNotNull((Object)nbt);
            return AEItemStack.fromNBT(nbt);
        }

        @Override
        public IAEItemStack readFromPacket(PacketBuffer input) {
            Preconditions.checkNotNull((Object)input);
            return AEItemStack.fromPacket(input);
        }
    }
}

