/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.network;

import appeng.core.sync.BasePacket;
import appeng.core.sync.network.ClientPacketHandler;
import appeng.core.sync.network.IPacketHandler;
import appeng.core.sync.network.ServerPacketHandler;
import appeng.core.sync.network.TargetPoint;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.ThreadQuickExitException;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.event.EventNetworkChannel;

public class NetworkHandler {
    private static NetworkHandler instance;
    private final ResourceLocation myChannelName;
    private final IPacketHandler clientHandler;
    private final IPacketHandler serverHandler;

    public NetworkHandler(ResourceLocation channelName) {
        this.myChannelName = channelName;
        EventNetworkChannel ec = NetworkRegistry.ChannelBuilder.named((ResourceLocation)this.myChannelName).networkProtocolVersion(() -> "1").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).eventNetworkChannel();
        ec.registerObject((Object)this);
        this.clientHandler = (IPacketHandler)DistExecutor.unsafeRunForDist(() -> ClientPacketHandler::new, () -> () -> null);
        this.serverHandler = this.createServerSide();
    }

    public static void init(ResourceLocation channelName) {
        instance = new NetworkHandler(channelName);
    }

    public static NetworkHandler instance() {
        return instance;
    }

    private IPacketHandler createServerSide() {
        try {
            return new ServerPacketHandler();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @SubscribeEvent
    public void serverPacket(NetworkEvent.ClientCustomPayloadEvent ev) {
        if (this.serverHandler != null) {
            try {
                NetworkEvent.Context ctx = (NetworkEvent.Context)ev.getSource().get();
                ServerPlayNetHandler netHandler = (ServerPlayNetHandler)ctx.getNetworkManager().func_150729_e();
                ctx.setPacketHandled(true);
                ctx.enqueueWork(() -> this.serverHandler.onPacketData(null, (INetHandler)netHandler, ev.getPayload(), (PlayerEntity)netHandler.field_147369_b));
            }
            catch (ThreadQuickExitException threadQuickExitException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void clientPacket(NetworkEvent.ServerCustomPayloadEvent ev) {
        if (ev instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
            return;
        }
        if (this.clientHandler != null) {
            try {
                NetworkEvent.Context ctx = (NetworkEvent.Context)ev.getSource().get();
                INetHandler netHandler = ctx.getNetworkManager().func_150729_e();
                ctx.setPacketHandled(true);
                ctx.enqueueWork(() -> this.clientHandler.onPacketData(null, netHandler, ev.getPayload(), null));
            }
            catch (ThreadQuickExitException threadQuickExitException) {
                // empty catch block
            }
        }
    }

    public ResourceLocation getChannel() {
        return this.myChannelName;
    }

    public void sendToAll(BasePacket message) {
        this.getServer().func_184103_al().func_148540_a(message.toPacket(NetworkDirection.PLAY_TO_CLIENT));
    }

    public void sendTo(BasePacket message, ServerPlayerEntity player) {
        player.field_71135_a.func_147359_a(message.toPacket(NetworkDirection.PLAY_TO_CLIENT));
    }

    public void sendToAllAround(BasePacket message, TargetPoint point) {
        IPacket<?> pkt = message.toPacket(NetworkDirection.PLAY_TO_CLIENT);
        this.getServer().func_184103_al().func_148543_a((PlayerEntity)point.excluded, point.x, point.y, point.z, point.r2, point.dim, pkt);
    }

    public void sendToDimension(BasePacket message, DimensionType dim) {
        this.getServer().func_184103_al().func_148537_a(message.toPacket(NetworkDirection.PLAY_TO_CLIENT), dim);
    }

    public void sendToServer(BasePacket message) {
        Minecraft.func_71410_x().func_147114_u().func_147297_a(message.toPacket(NetworkDirection.PLAY_TO_SERVER));
    }

    private MinecraftServer getServer() {
        return (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
    }
}

