/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.AEPartLocation;
import appeng.client.render.effects.EnergyParticleData;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.Platform;
import io.netty.buffer.Unpooled;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.GameData;

public class BlockTransitionEffectPacket
extends BasePacket {
    private final BlockPos pos;
    private final BlockState blockState;
    private final AEPartLocation direction;
    private final SoundMode soundMode;

    public BlockTransitionEffectPacket(BlockPos pos, BlockState blockState, AEPartLocation direction, SoundMode soundMode) {
        this.pos = pos;
        this.blockState = blockState;
        this.direction = direction;
        this.soundMode = soundMode;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.func_179255_a(pos);
        int blockStateId = GameData.getBlockStateIDMap().func_148747_b((Object)blockState);
        if (blockStateId == -1) {
            AELog.warn("Failed to find numeric id for block state %s", blockState);
        }
        data.writeInt(blockStateId);
        data.writeByte(this.direction.ordinal());
        data.writeByte((int)((byte)soundMode.ordinal()));
        this.configureWrite(data);
    }

    public BlockTransitionEffectPacket(PacketBuffer stream) {
        this.pos = stream.func_179259_c();
        int blockStateId = stream.readInt();
        BlockState blockState = (BlockState)GameData.getBlockStateIDMap().func_148745_a(blockStateId);
        if (blockState == null) {
            AELog.warn("Received invalid blockstate id %d from server", blockStateId);
            blockState = Blocks.field_150350_a.func_176223_P();
        }
        this.blockState = blockState;
        this.direction = AEPartLocation.fromOrdinal(stream.readByte());
        this.soundMode = SoundMode.values()[stream.readByte()];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        this.spawnParticles();
        this.playBreakOrPickupSound();
    }

    private void spawnParticles() {
        EnergyParticleData data = new EnergyParticleData(false, this.direction);
        for (int zz = 0; zz < 32; ++zz) {
            if (!AppEng.proxy.shouldAddParticles(Platform.getRandom())) continue;
            double x = (float)this.pos.func_177958_n() + Platform.getRandomFloat();
            double y = (float)this.pos.func_177956_o() + Platform.getRandomFloat();
            double z = (float)this.pos.func_177952_p() + Platform.getRandomFloat();
            double speedX = 0.1f * (float)this.direction.xOffset;
            double speedY = 0.1f * (float)this.direction.yOffset;
            double speedZ = 0.1f * (float)this.direction.zOffset;
            Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)data, x, y, z, speedX, speedY, speedZ);
        }
    }

    private void playBreakOrPickupSound() {
        float pitch;
        float volume;
        SoundEvent soundEvent;
        if (this.soundMode == SoundMode.FLUID) {
            Fluid fluid = this.blockState.func_204520_s().func_206886_c();
            soundEvent = fluid.getAttributes().getFillSound();
            if (soundEvent == null) {
                soundEvent = fluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
            }
            volume = 1.0f;
            pitch = 1.0f;
        } else if (this.soundMode == SoundMode.BLOCK) {
            SoundType soundType = this.blockState.func_215695_r();
            soundEvent = soundType.func_185845_c();
            volume = soundType.field_185860_m;
            pitch = soundType.field_185861_n;
        } else {
            return;
        }
        SimpleSound sound = new SimpleSound(soundEvent, SoundCategory.BLOCKS, (volume + 1.0f) / 2.0f, pitch * 0.8f, this.pos);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
    }

    public static enum SoundMode {
        BLOCK,
        FLUID,
        NONE;

    }
}

