/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.gui.implementations.InterfaceTerminalScreen;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CompressedNBTPacket
extends BasePacket {
    private final CompoundNBT in;
    private final PacketBuffer data;
    private final GZIPOutputStream compressFrame;

    public CompressedNBTPacket(final PacketBuffer stream) {
        this.data = null;
        this.compressFrame = null;
        try (DataInputStream inStream = new DataInputStream(new GZIPInputStream(new InputStream(){

            @Override
            public int read() {
                if (stream.readableBytes() <= 0) {
                    return -1;
                }
                return stream.readByte() & 0xFF;
            }
        }));){
            this.in = CompressedStreamTools.func_74794_a((DataInputStream)inStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to decompress packet.", e);
        }
    }

    public CompressedNBTPacket(CompoundNBT din) throws IOException {
        this.data = new PacketBuffer(Unpooled.buffer((int)2048));
        this.data.writeInt(this.getPacketID());
        this.in = din;
        this.compressFrame = new GZIPOutputStream(new OutputStream(){

            @Override
            public void write(int value) {
                CompressedNBTPacket.this.data.writeByte(value);
            }
        });
        CompressedStreamTools.func_74800_a((CompoundNBT)din, (DataOutput)new DataOutputStream(this.compressFrame));
        this.compressFrame.close();
        this.configureWrite(this.data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        Screen gs = Minecraft.func_71410_x().field_71462_r;
        if (gs instanceof InterfaceTerminalScreen) {
            ((InterfaceTerminalScreen)gs).postUpdate(this.in);
        }
    }
}

