/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.Api;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.IContainerCraftingPacket;
import appeng.items.storage.ViewCellItem;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.WrapperInvItemHandler;
import appeng.util.item.AEItemStack;
import appeng.util.prioritylist.IPartitionList;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;

public class JEIRecipePacket
extends BasePacket {
    private ItemStack[][] recipe;

    public JEIRecipePacket(PacketBuffer stream) {
        CompoundNBT comp = stream.func_150793_b();
        if (comp != null) {
            this.recipe = new ItemStack[9][];
            for (int x = 0; x < this.recipe.length; ++x) {
                ListNBT list = comp.func_150295_c("#" + x, 10);
                if (list.size() <= 0) continue;
                this.recipe[x] = new ItemStack[list.size()];
                for (int y = 0; y < list.size(); ++y) {
                    this.recipe[x][y] = ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(y));
                }
            }
        }
    }

    public JEIRecipePacket(CompoundNBT recipe) {
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.func_150786_a(recipe);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        ServerPlayerEntity pmp = (ServerPlayerEntity)player;
        Container con = pmp.field_71070_bA;
        if (!(con instanceof IContainerCraftingPacket)) {
            return;
        }
        IContainerCraftingPacket cct = (IContainerCraftingPacket)con;
        IGridNode node = cct.getNetworkNode();
        if (node == null) {
            return;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return;
        }
        IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
        IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        ICraftingGrid crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        IItemHandler craftMatrix = cct.getInventoryByName("crafting");
        IItemHandler playerInventory = cct.getInventoryByName("player");
        if (inv != null && this.recipe != null && security != null) {
            IMEMonitor<IAEItemStack> storage = inv.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IPartitionList<IAEItemStack> filter = ViewCellItem.createFilter(cct.getViewCells());
            for (int x = 0; x < craftMatrix.getSlots(); ++x) {
                IAEItemStack out;
                ItemStack newItem;
                ItemStack currentItem = craftMatrix.getStackInSlot(x);
                if (!currentItem.func_190926_b() && (newItem = this.canUseInSlot(x, currentItem)) != currentItem && security.hasPermission(player, SecurityPermissions.INJECT)) {
                    AEItemStack in = AEItemStack.fromItemStack(currentItem);
                    out = cct.useRealItems() ? (IAEItemStack)Platform.poweredInsert(energy, storage, in, cct.getActionSource()) : null;
                    currentItem = out != null ? out.createItemStack() : ItemStack.field_190927_a;
                }
                if (currentItem.func_190926_b() && this.recipe[x] != null) {
                    for (int y = 0; y < this.recipe[x].length && currentItem.func_190926_b(); ++y) {
                        AEItemStack request = AEItemStack.fromItemStack(this.recipe[x][y]);
                        if (request == null) continue;
                        if ((filter == null || filter.isListed(request)) && security.hasPermission(player, SecurityPermissions.EXTRACT)) {
                            request.setStackSize(1L);
                            out = cct.useRealItems() ? (IAEItemStack)Platform.poweredExtraction(energy, storage, request, cct.getActionSource()) : (!crafting.getCraftingFor(request, null, 0, null).isEmpty() ? request : storage.extractItems(request, Actionable.SIMULATE, cct.getActionSource()));
                            if (out != null) {
                                currentItem = out.createItemStack();
                            }
                        }
                        if (!currentItem.func_190926_b()) continue;
                        AdaptorItemHandler ad = new AdaptorItemHandler(playerInventory);
                        currentItem = cct.useRealItems() ? ad.removeItems(1, this.recipe[x][y], null) : ad.simulateRemove(1, this.recipe[x][y], null);
                    }
                }
                ItemHandlerUtil.setStackInSlot(craftMatrix, x, currentItem);
            }
            con.func_75130_a((IInventory)new WrapperInvItemHandler(craftMatrix));
        }
    }

    private ItemStack canUseInSlot(int slot, ItemStack is) {
        if (this.recipe[slot] != null) {
            for (ItemStack option : this.recipe[slot]) {
                if (!is.func_77969_a(option)) continue;
                return is;
            }
        }
        return ItemStack.field_190927_a;
    }
}

