/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.implementations.CraftConfirmScreen;
import appeng.client.gui.implementations.CraftingCPUScreen;
import appeng.client.gui.implementations.MEMonitorableScreen;
import appeng.client.gui.implementations.NetworkStatusScreen;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.item.AEItemStack;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;

public class MEInventoryUpdatePacket
extends BasePacket {
    private static final int UNCOMPRESSED_PACKET_BYTE_LIMIT = 0x1000000;
    private static final int OPERATION_BYTE_LIMIT = 2048;
    private static final int TEMP_BUFFER_SIZE = 1024;
    private static final int STREAM_MASK = 255;
    @Nullable
    private final List<IAEItemStack> list;
    private final byte ref;
    @Nullable
    private final PacketBuffer data;
    @Nullable
    private final GZIPOutputStream compressFrame;
    private int writtenBytes = 0;
    private boolean empty = true;

    public MEInventoryUpdatePacket(final PacketBuffer stream) {
        this.data = null;
        this.compressFrame = null;
        this.list = new ArrayList<IAEItemStack>();
        this.ref = stream.readByte();
        try (GZIPInputStream gzReader = new GZIPInputStream(new InputStream(){

            @Override
            public int read() {
                if (stream.readableBytes() <= 0) {
                    return -1;
                }
                return stream.readByte() & 0xFF;
            }
        });){
            PacketBuffer uncompressed = new PacketBuffer(Unpooled.buffer((int)stream.readableBytes()));
            byte[] tmp = new byte[1024];
            while (gzReader.available() != 0) {
                int bytes = gzReader.read(tmp);
                if (bytes <= 0) continue;
                uncompressed.writeBytes(tmp, 0, bytes);
            }
            while (uncompressed.readableBytes() > 0) {
                this.list.add(AEItemStack.fromPacket(uncompressed));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to decompress packet.", e);
        }
        this.empty = this.list.isEmpty();
    }

    public MEInventoryUpdatePacket() throws IOException {
        this(0);
    }

    public MEInventoryUpdatePacket(byte ref) throws IOException {
        this.ref = ref;
        this.data = new PacketBuffer(Unpooled.buffer((int)2048));
        this.data.writeInt(this.getPacketID());
        this.data.writeByte((int)this.ref);
        this.compressFrame = new GZIPOutputStream(new OutputStream(){

            @Override
            public void write(int value) {
                MEInventoryUpdatePacket.this.data.writeByte(value);
            }
        });
        this.list = null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        Screen gs = Minecraft.func_71410_x().field_71462_r;
        if (gs instanceof CraftConfirmScreen) {
            ((CraftConfirmScreen)gs).postUpdate(this.list, this.ref);
        }
        if (gs instanceof CraftingCPUScreen) {
            ((CraftingCPUScreen)gs).postUpdate(this.list, this.ref);
        }
        if (gs instanceof MEMonitorableScreen) {
            ((MEMonitorableScreen)gs).postUpdate(this.list);
        }
        if (gs instanceof NetworkStatusScreen) {
            ((NetworkStatusScreen)gs).postUpdate(this.list);
        }
    }

    @Override
    @Nullable
    public IPacket<?> toPacket(NetworkDirection direction) {
        try {
            this.compressFrame.close();
            this.configureWrite(this.data);
            return super.toPacket(direction);
        }
        catch (IOException e) {
            AELog.debug(e);
            return null;
        }
    }

    public void appendItem(IAEItemStack is) throws IOException, BufferOverflowException {
        PacketBuffer tmp = new PacketBuffer(Unpooled.buffer((int)2048));
        is.writeToPacket(tmp);
        this.compressFrame.flush();
        if (this.writtenBytes + tmp.readableBytes() > 0x1000000) {
            throw new BufferOverflowException();
        }
        this.writtenBytes += tmp.readableBytes();
        this.compressFrame.write(tmp.array(), 0, tmp.readableBytes());
        this.empty = false;
    }

    public int getLength() {
        return this.data.readableBytes();
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

