/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.container.AEBaseContainer;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;

public class ProgressBarPacket
extends BasePacket {
    private final short id;
    private final long value;

    public ProgressBarPacket(PacketBuffer stream) {
        this.id = stream.readShort();
        this.value = stream.readLong();
    }

    public ProgressBarPacket(int shortID, long value) {
        this.id = (short)shortID;
        this.value = value;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeShort(shortID);
        data.writeLong(value);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        Container c = player.field_71070_bA;
        if (c instanceof AEBaseContainer) {
            ((AEBaseContainer)c).updateFullProgressBar(this.id, this.value);
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        Container c = player.field_71070_bA;
        if (c instanceof AEBaseContainer) {
            ((AEBaseContainer)c).updateFullProgressBar(this.id, this.value);
        }
    }
}

