/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import appeng.hooks.TickHandler;
import appeng.items.AEBaseItem;
import appeng.me.Grid;
import appeng.me.GridNode;
import appeng.me.cache.TickManagerCache;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.tile.networking.ControllerTileEntity;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class DebugCardItem
extends AEBaseItem {
    public DebugCardItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195991_k().func_201670_d()) {
            return ActionResultType.PASS;
        }
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        if (player == null) {
            return ActionResultType.PASS;
        }
        if (player.func_213453_ef()) {
            int grids = 0;
            int totalNodes = 0;
            for (Grid g : TickHandler.INSTANCE.getGridList()) {
                ++grids;
                totalNodes += g.getNodes().size();
            }
            this.outputMsg((Entity)player, "Grids: " + grids);
            this.outputMsg((Entity)player, "Total Nodes: " + totalNodes);
        } else {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IGridHost) {
                GridNode node = (GridNode)((IGridHost)te).getGridNode(AEPartLocation.fromFacing(side));
                if (node != null) {
                    Grid g = node.getInternalGrid();
                    IGridNode center = g.getPivot();
                    this.outputMsg((Entity)player, "This Node: " + node.toString());
                    this.outputMsg((Entity)player, "Center Node: " + center.toString());
                    IPathingGrid pg = (IPathingGrid)g.getCache(IPathingGrid.class);
                    if (pg.getControllerState() == ControllerState.CONTROLLER_ONLINE) {
                        HashSet<IGridNode> next = new HashSet<IGridNode>();
                        next.add(node);
                        int maxLength = 10000;
                        int length = 0;
                        block1: while (!next.isEmpty()) {
                            HashSet<IGridNode> current = next;
                            next = new HashSet();
                            for (IGridNode n : current) {
                                if (n.getMachine() instanceof ControllerTileEntity) break block1;
                                for (IGridConnection c : n.getConnections()) {
                                    next.add(c.getOtherSide(n));
                                }
                            }
                            if (++length <= 10000) continue;
                            break;
                        }
                        this.outputMsg((Entity)player, "Cable Distance: " + length);
                    }
                    if (center.getMachine() instanceof P2PTunnelPart) {
                        this.outputMsg((Entity)player, "Freq: " + ((P2PTunnelPart)center.getMachine()).getFrequency());
                    }
                    TickManagerCache tmc = (TickManagerCache)g.getCache(ITickManager.class);
                    for (Class<? extends IGridHost> c : g.getMachineClasses()) {
                        int o = 0;
                        long nanos = 0L;
                        for (IGridNode oj : g.getMachines(c)) {
                            ++o;
                            nanos += tmc.getAvgNanoTime(oj);
                        }
                        if (nanos < 0L) {
                            this.outputMsg((Entity)player, c.getSimpleName() + " - " + o);
                            continue;
                        }
                        this.outputMsg((Entity)player, c.getSimpleName() + " - " + o + "; " + this.timeMeasurement(nanos));
                    }
                } else {
                    this.outputMsg((Entity)player, "No Node Available.");
                }
            } else {
                this.outputMsg((Entity)player, "Not Networked Block");
            }
            if (te instanceof IPartHost) {
                IPart center = ((IPartHost)te).getPart(AEPartLocation.INTERNAL);
                ((IPartHost)te).markForUpdate();
                if (center != null) {
                    GridNode n = (GridNode)center.getGridNode();
                    this.outputMsg((Entity)player, "Node Channels: " + n.usedChannels());
                    for (IGridConnection gc : n.getConnections()) {
                        AEPartLocation fd = gc.getDirection(n);
                        if (fd == AEPartLocation.INTERNAL) continue;
                        this.outputMsg((Entity)player, fd.toString() + ": " + gc.getUsedChannels());
                    }
                }
            }
            if (te instanceof IAEPowerStorage) {
                IGridNode node;
                IAEPowerStorage ps = (IAEPowerStorage)te;
                this.outputMsg((Entity)player, "Energy: " + ps.getAECurrentPower() + " / " + ps.getAEMaxPower());
                if (te instanceof IGridHost && (node = ((IGridHost)te).getGridNode(AEPartLocation.fromFacing(side))) != null && node.getGrid() != null) {
                    IEnergyGrid eg = (IEnergyGrid)node.getGrid().getCache(IEnergyGrid.class);
                    this.outputMsg((Entity)player, "GridEnergy: " + eg.getStoredPower() + " : " + eg.getEnergyDemand(Double.MAX_VALUE));
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void outputMsg(Entity player, String string) {
        player.func_145747_a((ITextComponent)new StringTextComponent(string));
    }

    private String timeMeasurement(long nanos) {
        long ms = nanos / 100000L;
        if (nanos <= 100000L) {
            return nanos + "ns";
        }
        return (float)ms / 10.0f + "ms";
    }
}

