/*
 * Decompiled with CFR 0.152.
 */
package appeng.decorative.solid;

import appeng.block.AEBaseBlock;
import appeng.core.worlddata.WorldData;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SkyStoneBlock
extends AEBaseBlock {
    private static final float BREAK_SPEAK_SCALAR = 0.1f;
    private static final double BREAK_SPEAK_THRESHOLD = 7.0;
    private final SkystoneType type;

    public SkyStoneBlock(SkystoneType type, Block.Properties props) {
        super(props);
        this.type = type;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void breakFaster(PlayerEvent.BreakSpeed event) {
        if (event.getState().func_177230_c() == this && event.getPlayer() != null) {
            ItemStack is = event.getPlayer().func_184582_a(EquipmentSlotType.MAINHAND);
            int level = -1;
            if (!is.func_190926_b()) {
                level = is.func_77973_b().getHarvestLevel(is, ToolType.PICKAXE, event.getPlayer(), event.getState());
            }
            if (this.type != SkystoneType.STONE || level >= 3 || (double)event.getOriginalSpeed() > 7.0) {
                event.setNewSpeed(event.getNewSpeed() / 0.1f);
            }
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (worldIn instanceof ServerWorld) {
            WorldData.instance().compassData().service().updateArea(worldIn, new ChunkPos(currentPos), currentPos.func_177956_o());
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_196243_a(BlockState state, World w, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() == state.func_177230_c()) {
            return;
        }
        super.func_196243_a(state, w, pos, newState, isMoving);
        if (w instanceof ServerWorld) {
            WorldData.instance().compassData().service().updateArea((IWorld)w, new ChunkPos(pos), pos.func_177956_o());
        }
    }

    public static enum SkystoneType {
        STONE,
        BLOCK,
        BRICK,
        SMALL_BRICK;

    }
}

