/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.features.AEFeature;
import appeng.api.implementations.items.IGrowableCrystal;
import appeng.api.implementations.tiles.ICrystalGrowthAccelerator;
import appeng.client.EffectType;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.entity.AEBaseItemEntity;
import appeng.items.misc.CrystalSeedItem;
import appeng.util.Platform;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class GrowingCrystalEntity
extends AEBaseItemEntity {
    public static EntityType<GrowingCrystalEntity> TYPE;
    private int progress_1000 = 0;

    public GrowingCrystalEntity(EntityType<? extends GrowingCrystalEntity> type, World world) {
        super(type, world);
    }

    public GrowingCrystalEntity(World w, double x, double y, double z, ItemStack is) {
        super(TYPE, w, x, y, z, is);
        this.func_174873_u();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_PURIFICATION)) {
            return;
        }
        ItemStack is = this.func_92059_d();
        Item gc = is.func_77973_b();
        if (gc instanceof IGrowableCrystal) {
            int j = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int i = MathHelper.func_76128_c((double)((this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0));
            int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
            BlockState state = this.field_70170_p.func_180495_p(new BlockPos(j, i, k));
            Material mat = state.func_185904_a();
            IGrowableCrystal cry = (IGrowableCrystal)is.func_77973_b();
            float multiplier = cry.getMultiplier(state.func_177230_c(), mat);
            int speed = (int)Math.max(1.0f, (float)this.getSpeed(j, i, k) * multiplier);
            boolean isClient = Platform.isClient();
            this.progress_1000 = mat.func_76224_d() ? (isClient ? ++this.progress_1000 : (this.progress_1000 += speed)) : 0;
            if (isClient) {
                int len = 40;
                if (speed > 2) {
                    len = 20;
                }
                if (speed > 90) {
                    len = 15;
                }
                if (speed > 150) {
                    len = 10;
                }
                if (speed > 240) {
                    len = 7;
                }
                if (speed > 360) {
                    len = 3;
                }
                if (speed > 500) {
                    len = 1;
                }
                if (this.progress_1000 >= len) {
                    this.progress_1000 = 0;
                    AppEng.proxy.spawnEffect(EffectType.Vibrant, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.2, this.func_226281_cx_(), null);
                }
            } else if (this.progress_1000 > 1000) {
                this.progress_1000 -= 1000;
                ItemStack newItem = cry.triggerGrowth(is.func_77946_l());
                this.func_92058_a(newItem);
            }
        }
    }

    private int getSpeed(int x, int y, int z) {
        int per = 80;
        float mul = 0.3f;
        int qty = 0;
        if (this.isAccelerated(x + 1, y, z)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x, y + 1, z)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x, y, z + 1)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x - 1, y, z)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x, y - 1, z)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x, y, z - 1)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        return qty;
    }

    private boolean isAccelerated(int x, int y, int z) {
        TileEntity te = this.field_70170_p.func_175625_s(new BlockPos(x, y, z));
        return te instanceof ICrystalGrowthAccelerator && ((ICrystalGrowthAccelerator)te).isPowered();
    }

    protected void func_203043_v() {
        ItemStack item = this.func_92059_d();
        if (item.func_77973_b() instanceof CrystalSeedItem) {
            return;
        }
        super.func_203043_v();
    }
}

