/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui;

import appeng.api.config.AccessRestriction;
import appeng.api.config.ActionItems;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.TabButton;
import appeng.container.implementations.PriorityContainer;
import appeng.container.slot.IOptionalSlotHost;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.fluids.client.gui.widgets.FluidSlotWidget;
import appeng.fluids.client.gui.widgets.OptionalFluidSlotWidget;
import appeng.fluids.container.FluidStorageBusContainer;
import appeng.fluids.util.IAEFluidTank;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class FluidStorageBusScreen
extends UpgradeableScreen<FluidStorageBusContainer> {
    private SettingToggleButton<AccessRestriction> rwMode;
    private SettingToggleButton<StorageFilter> storageFilter;

    public FluidStorageBusScreen(FluidStorageBusContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.field_147000_g = 251;
    }

    @Override
    public void init() {
        super.init();
        int xo = 8;
        int yo = 29;
        IAEFluidTank config = ((FluidStorageBusContainer)this.field_147002_h).getFluidConfigInventory();
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 9; ++x) {
                int idx = y * 9 + x;
                if (y < 2) {
                    this.guiSlots.add(new FluidSlotWidget(config, idx, idx, 8 + x * 18, 29 + y * 18));
                    continue;
                }
                this.guiSlots.add(new OptionalFluidSlotWidget(config, (IOptionalSlotHost)this.field_147002_h, idx, idx, y - 2, 8, 29, x, y));
            }
        }
    }

    @Override
    protected void addButtons() {
        this.addButton((Widget)new ActionButton(this.field_147003_i - 18, this.field_147009_r + 8, ActionItems.CLOSE, btn -> this.clear()));
        this.addButton((Widget)new ActionButton(this.field_147003_i - 18, this.field_147009_r + 28, ActionItems.WRENCH, btn -> this.partition()));
        this.rwMode = new ServerSettingToggleButton<AccessRestriction>(this.field_147003_i - 18, this.field_147009_r + 48, Settings.ACCESS, AccessRestriction.READ_WRITE);
        this.storageFilter = new ServerSettingToggleButton<StorageFilter>(this.field_147003_i - 18, this.field_147009_r + 68, Settings.STORAGE_FILTER, StorageFilter.EXTRACTABLE_ONLY);
        this.fuzzyMode = new ServerSettingToggleButton<FuzzyMode>(this.field_147003_i - 18, this.field_147009_r + 88, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.addButton(this.addButton((Widget)new TabButton(this.field_147003_i + 154, this.field_147009_r, 66, GuiText.Priority.getLocal(), this.itemRenderer, btn -> this.openPriorityGui())));
        this.addButton((Widget)this.storageFilter);
        this.addButton((Widget)this.fuzzyMode);
        this.addButton((Widget)this.rwMode);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.font.func_211126_b(this.getGuiDisplayName(this.getName().getLocal()), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(GuiText.inventory.getLocal(), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
        if (this.fuzzyMode != null) {
            this.fuzzyMode.set(this.cvb.getFuzzyMode());
        }
        if (this.storageFilter != null) {
            this.storageFilter.set(((FluidStorageBusContainer)this.cvb).getStorageFilter());
        }
        if (this.rwMode != null) {
            this.rwMode.set(((FluidStorageBusContainer)this.cvb).getReadWriteMode());
        }
    }

    @Override
    protected String getBackground() {
        return "guis/storagebus.png";
    }

    private void partition() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("StorageBus.Action", "Partition"));
    }

    private void clear() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("StorageBus.Action", "Clear"));
    }

    private void openPriorityGui() {
        NetworkHandler.instance().sendToServer(new SwitchGuisPacket(PriorityContainer.TYPE));
    }

    @Override
    protected GuiText getName() {
        return GuiText.StorageBusFluids;
    }
}

