/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui.widgets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEColor;
import appeng.client.gui.widgets.ITooltip;
import appeng.fluids.util.IAEFluidTank;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;

@OnlyIn(value=Dist.CLIENT)
public class FluidTankWidget
extends Widget
implements ITooltip {
    private final IAEFluidTank tank;
    private final int slot;

    public FluidTankWidget(IAEFluidTank tank, int slot, int x, int y, int w, int h) {
        super(x, y, w, h, "");
        this.tank = tank;
        this.slot = slot;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            RenderSystem.disableBlend();
            FluidTankWidget.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)(AEColor.GRAY.blackVariant | 0xFF000000));
            IAEFluidStack fluidStack = this.tank.getFluidInSlot(this.slot);
            if (fluidStack != null && fluidStack.getStackSize() > 0L) {
                Fluid fluid = fluidStack.getFluid();
                FluidAttributes attributes = fluid.getAttributes();
                float red = (float)(attributes.getColor() >> 16 & 0xFF) / 255.0f;
                float green = (float)(attributes.getColor() >> 8 & 0xFF) / 255.0f;
                float blue = (float)(attributes.getColor() & 0xFF) / 255.0f;
                RenderSystem.color3f((float)red, (float)green, (float)blue);
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                TextureAtlasSprite sprite = (TextureAtlasSprite)mc.func_228015_a_(AtlasTexture.field_110575_b).apply(attributes.getStillTexture(fluidStack.getFluidStack()));
                int scaledHeight = (int)((float)this.height * ((float)fluidStack.getStackSize() / (float)this.tank.getTankCapacity(this.slot)));
                int iconHeightRemainder = scaledHeight % 16;
                if (iconHeightRemainder > 0) {
                    FluidTankWidget.blit((int)this.x, (int)(this.y + this.height - iconHeightRemainder), (int)this.getBlitOffset(), (int)16, (int)iconHeightRemainder, (TextureAtlasSprite)sprite);
                }
                for (int i = 0; i < scaledHeight / 16; ++i) {
                    FluidTankWidget.blit((int)this.x, (int)(this.y + this.height - iconHeightRemainder - (i + 1) * 16), (int)this.getBlitOffset(), (int)16, (int)16, (TextureAtlasSprite)sprite);
                }
            }
        }
    }

    @Override
    public String getMessage() {
        IAEFluidStack fluid = this.tank.getFluidInSlot(this.slot);
        if (fluid != null && fluid.getStackSize() > 0L) {
            String desc = fluid.getFluid().getAttributes().getDisplayName(fluid.getFluidStack()).func_150254_d();
            String amountToText = fluid.getStackSize() + "mB";
            return desc + "\n" + amountToText;
        }
        return null;
    }

    @Override
    public int xPos() {
        return this.x - 2;
    }

    @Override
    public int yPos() {
        return this.y - 2;
    }

    @Override
    public int getWidth() {
        return this.width + 4;
    }

    @Override
    public int getHeight() {
        return this.height + 4;
    }

    @Override
    public boolean isVisible() {
        return true;
    }
}

