/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.container.implementations.UpgradeableContainer;
import appeng.fluids.container.IFluidSyncContainer;
import appeng.fluids.helper.FluidSyncHelper;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidTank;
import appeng.util.Platform;
import java.util.Collections;
import java.util.Map;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public abstract class FluidConfigurableContainer
extends UpgradeableContainer
implements IFluidSyncContainer {
    private FluidSyncHelper sync = null;

    public FluidConfigurableContainer(ContainerType<?> containerType, int id, PlayerInventory ip, IUpgradeableHost te) {
        super(containerType, id, ip, te);
    }

    public abstract IAEFluidTank getFluidConfigInventory();

    private FluidSyncHelper getSyncHelper() {
        if (this.sync == null) {
            this.sync = new FluidSyncHelper(this.getFluidConfigInventory(), 0);
        }
        return this.sync;
    }

    @Override
    protected ItemStack transferStackToContainer(ItemStack input) {
        LazyOptional fsOpt = FluidUtil.getFluidContained((ItemStack)input);
        if (fsOpt.isPresent()) {
            IAEFluidTank t = this.getFluidConfigInventory();
            AEFluidStack stack = AEFluidStack.fromFluidStack((FluidStack)fsOpt.orElse(null));
            for (int i = 0; i < t.getSlots(); ++i) {
                if (t.getFluidInSlot(i) != null || !this.isValidForConfig(i, stack)) continue;
                t.setFluidInSlot(i, stack);
                break;
            }
        }
        return input;
    }

    protected boolean isValidForConfig(int slot, IAEFluidStack fs) {
        if (this.supportCapacity()) {
            int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
            if (slot > 0 && upgrades < 1) {
                return false;
            }
            if (slot > 4 && upgrades < 2) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void standardDetectAndSendChanges() {
        if (Platform.isServer()) {
            this.getSyncHelper().sendDiff(this.field_75149_d);
            IAEFluidTank t = this.getFluidConfigInventory();
            for (int i = 0; i < t.getSlots(); ++i) {
                if (t.getFluidInSlot(i) == null || this.isValidForConfig(i, t.getFluidInSlot(i))) continue;
                t.setFluidInSlot(i, null);
            }
        }
        super.standardDetectAndSendChanges();
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.getSyncHelper().sendFull(Collections.singleton(listener));
    }

    @Override
    public void receiveFluidSlots(Map<Integer, IAEFluidStack> fluids) {
        this.getSyncHelper().readPacket(fluids);
    }
}

