/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.fluids.container.FluidConfigurableContainer;
import appeng.fluids.parts.FluidLevelEmitterPart;
import appeng.fluids.util.IAEFluidTank;
import appeng.util.Platform;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FluidLevelEmitterContainer
extends FluidConfigurableContainer {
    public static ContainerType<FluidLevelEmitterContainer> TYPE;
    private static final ContainerHelper<FluidLevelEmitterContainer, FluidLevelEmitterPart> helper;
    private final FluidLevelEmitterPart lvlEmitter;
    @OnlyIn(value=Dist.CLIENT)
    private TextFieldWidget textField;
    @GuiSync(value=3)
    public long EmitterValue = -1L;

    public static FluidLevelEmitterContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public FluidLevelEmitterContainer(int id, PlayerInventory ip, FluidLevelEmitterPart te) {
        super(TYPE, id, ip, te);
        this.lvlEmitter = te;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setTextField(TextFieldWidget level) {
        this.textField = level;
        this.textField.func_146180_a(String.valueOf(this.EmitterValue));
    }

    public void setLevel(long l, PlayerEntity player) {
        this.lvlEmitter.setReportingValue(l);
        this.EmitterValue = l;
    }

    @Override
    protected void setupConfig() {
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 0;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            this.EmitterValue = this.lvlEmitter.getReportingValue();
            this.setRedStoneMode((RedstoneMode)this.getUpgradeable().getConfigManager().getSetting(Settings.REDSTONE_EMITTER));
        }
        this.standardDetectAndSendChanges();
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("EmitterValue") && this.textField != null) {
            this.textField.func_146180_a(String.valueOf(this.EmitterValue));
        }
    }

    @Override
    public IAEFluidTank getFluidConfigInventory() {
        return this.lvlEmitter.getConfig();
    }

    static {
        helper = new ContainerHelper<FluidLevelEmitterContainer, FluidLevelEmitterPart>(FluidLevelEmitterContainer::new, FluidLevelEmitterPart.class, SecurityPermissions.BUILD);
    }
}

