/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.parts;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.settings.TickRates;
import appeng.core.sync.packets.BlockTransitionEffectPacket;
import appeng.fluids.util.AEFluidStack;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.BasicStatePart;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModelData;
import appeng.parts.automation.PlaneModels;
import appeng.util.Platform;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;

public class FluidAnnihilationPlanePart
extends BasicStatePart
implements IGridTickable {
    public static final ResourceLocation TAG_BLACKLIST = new ResourceLocation("appliedenergistics2", "blacklisted/fluid_annihilation_plane");
    private static final PlaneModels MODELS = new PlaneModels("part/fluid_annihilation_plane", "part/fluid_annihilation_plane_on");
    private final IActionSource mySrc = new MachineSource(this);

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public FluidAnnihilationPlanePart(ItemStack is) {
        super(is);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        boolean minX = true;
        boolean minY = true;
        int maxX = 15;
        int maxY = 15;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            BlockPos pos = te.func_174877_v();
            Direction e = bch.getWorldX();
            Direction u = bch.getWorldY();
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e.func_176734_d())), this.getSide())) {
                minX = false;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e)), this.getSide())) {
                maxX = 16;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(u.func_176734_d())), this.getSide())) {
                minY = false;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e)), this.getSide())) {
                maxY = 16;
            }
        }
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox((double)minX, (double)minY, 15.0, maxX, maxY, 16.0);
    }

    public PlaneConnections getConnections() {
        Direction facingUp;
        Direction facingRight;
        AEPartLocation location = this.getSide();
        switch (location) {
            case UP: {
                facingRight = Direction.EAST;
                facingUp = Direction.NORTH;
                break;
            }
            case DOWN: {
                facingRight = Direction.WEST;
                facingUp = Direction.NORTH;
                break;
            }
            case NORTH: {
                facingRight = Direction.WEST;
                facingUp = Direction.UP;
                break;
            }
            case SOUTH: {
                facingRight = Direction.EAST;
                facingUp = Direction.UP;
                break;
            }
            case WEST: {
                facingRight = Direction.SOUTH;
                facingUp = Direction.UP;
                break;
            }
            case EAST: {
                facingRight = Direction.NORTH;
                facingUp = Direction.UP;
                break;
            }
            default: {
                return PlaneConnections.of(false, false, false, false);
            }
        }
        boolean left = false;
        boolean right = false;
        boolean down = false;
        boolean up = false;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            BlockPos pos = te.func_174877_v();
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingRight.func_176734_d())), this.getSide())) {
                left = true;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingRight)), this.getSide())) {
                right = true;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingUp.func_176734_d())), this.getSide())) {
                down = true;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingUp)), this.getSide())) {
                up = true;
            }
        }
        return PlaneConnections.of(up, right, down, left);
    }

    @Override
    public void onNeighborChanged(IBlockReader w, BlockPos pos, BlockPos neighbor) {
        if (pos.func_177972_a(this.getSide().getFacing()).equals((Object)neighbor)) {
            this.refresh();
        }
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    private boolean isAnnihilationPlane(TileEntity blockTileEntity, AEPartLocation side) {
        if (blockTileEntity instanceof IPartHost) {
            IPart p = ((IPartHost)blockTileEntity).getPart(side);
            return p != null && p.getClass() == this.getClass();
        }
        return false;
    }

    private void refresh() {
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.refresh();
        this.getHost().markForUpdate();
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.refresh();
        this.getHost().markForUpdate();
    }

    private TickRateModulation pickupFluid() {
        BlockPos pos;
        if (!this.getProxy().isActive()) {
            return TickRateModulation.SLEEP;
        }
        TileEntity te = this.getTile();
        World w = te.func_145831_w();
        BlockState blockstate = w.func_180495_p(pos = te.func_174877_v().func_177972_a(this.getSide().getFacing()));
        if (blockstate.func_177230_c() instanceof IBucketPickupHandler) {
            IFluidState fluidState = blockstate.func_204520_s();
            Fluid fluid = fluidState.func_206886_c();
            if (this.isFluidBlacklisted(fluid)) {
                return TickRateModulation.SLEEP;
            }
            if (fluid != Fluids.field_204541_a && fluidState.func_206889_d()) {
                AEFluidStack blockFluid = AEFluidStack.fromFluidStack(new FluidStack(fluidState.func_206886_c(), 1000));
                if (this.storeFluid(blockFluid, false)) {
                    fluid = ((IBucketPickupHandler)blockstate.func_177230_c()).func_204508_a((IWorld)w, pos, blockstate);
                    this.storeFluid(AEFluidStack.fromFluidStack(new FluidStack(fluid, 1000)), true);
                    AppEng.proxy.sendToAllNearExcept(null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 64.0, w, new BlockTransitionEffectPacket(pos, blockstate, this.getSide().getOpposite(), BlockTransitionEffectPacket.SoundMode.FLUID));
                    return TickRateModulation.URGENT;
                }
                return TickRateModulation.IDLE;
            }
        }
        return TickRateModulation.SLEEP;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.AnnihilationPlane.getMin(), TickRates.AnnihilationPlane.getMax(), false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.pickupFluid();
    }

    private boolean storeFluid(IAEFluidStack stack, boolean modulate) {
        try {
            IStorageGrid storage = this.getProxy().getStorage();
            IMEMonitor<IAEFluidStack> inv = storage.getInventory(Api.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            if (modulate) {
                IEnergyGrid energy = this.getProxy().getEnergy();
                return Platform.poweredInsert(energy, inv, stack, this.mySrc) == null;
            }
            float requiredPower = (float)stack.getStackSize() / Math.min(1.0f, (float)stack.getChannel().transferFactor());
            IEnergyGrid energy = this.getProxy().getEnergy();
            if (energy.extractAEPower(requiredPower, Actionable.SIMULATE, PowerMultiplier.CONFIG) < (double)requiredPower) {
                return false;
            }
            IAEFluidStack leftOver = inv.injectItems(stack, Actionable.SIMULATE, this.mySrc);
            return leftOver == null || leftOver.getStackSize() == 0L;
        }
        catch (GridAccessException gridAccessException) {
            return false;
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new PlaneModelData(this.getConnections());
    }

    private boolean isFluidBlacklisted(Fluid fluid) {
        Tag tag = FluidTags.func_226157_a_().func_199915_b(TAG_BLACKLIST);
        return fluid.func_207185_a(tag);
    }
}

