/*
 * Decompiled with CFR 0.152.
 */
package appeng.forge.data.providers.loot;

import appeng.forge.data.providers.IAE2DataProvider;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.ILootFunctionConsumer;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.SurvivesExplosion;
import net.minecraft.world.storage.loot.functions.ApplyBonus;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockDropProvider
extends BlockLootTables
implements IAE2DataProvider {
    private Map<Block, Function<Block, LootTable.Builder>> overrides = ImmutableMap.builder().put((Object)BLOCKS.matrixFrame().block(), $ -> LootTable.func_216119_b()).put((Object)BLOCKS.quartzOre().block(), b -> BlockDropProvider.func_218519_a((Block)BLOCKS.quartzOre().block(), (LootEntry.Builder)((LootEntry.Builder)BlockDropProvider.func_218552_a((IItemProvider)BLOCKS.quartzOre().block(), (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)MATERIALS.certusQuartzCrystal().item()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t)))))).put((Object)BLOCKS.quartzOreCharged().block(), b -> BlockDropProvider.func_218519_a((Block)BLOCKS.quartzOreCharged().block(), (LootEntry.Builder)((LootEntry.Builder)BlockDropProvider.func_218552_a((IItemProvider)BLOCKS.quartzOreCharged().block(), (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)MATERIALS.certusQuartzCrystalCharged().item()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t)))))).build();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path outputFolder;

    public BlockDropProvider(GatherDataEvent dataEvent) {
        this.outputFolder = dataEvent.getGenerator().func_200391_b();
    }

    public void func_200398_a(@Nonnull DirectoryCache cache) throws IOException {
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            if (!((ResourceLocation)entry.getKey()).func_110624_b().equals("appliedenergistics2")) continue;
            LootTable.Builder builder = this.overrides.getOrDefault(entry.getValue(), this::defaultBuilder).apply((Block)entry.getValue());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.toJson(builder), (Path)this.getPath(this.outputFolder, (ResourceLocation)entry.getKey()));
        }
    }

    private LootTable.Builder defaultBuilder(Block block) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)block);
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.func_110624_b() + "/loot_tables/blocks/" + id.func_110623_a() + ".json");
    }

    public JsonElement toJson(LootTable.Builder builder) {
        return LootTableManager.func_215301_a((LootTable)this.finishBuilding(builder));
    }

    @Nonnull
    public LootTable finishBuilding(LootTable.Builder builder) {
        return builder.func_216039_a(LootParameterSets.field_216267_h).func_216038_b();
    }

    @Nonnull
    public String func_200397_b() {
        return "Applied Energistics 2 Block Drops";
    }
}

