/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.ContainerNull;
import appeng.core.Api;
import appeng.items.misc.EncodedPatternItem;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class CraftingPatternDetails
implements ICraftingPatternDetails,
Comparable<CraftingPatternDetails> {
    private final CraftingInventory crafting = new CraftingInventory((Container)new ContainerNull(), 3, 3);
    private final CraftingInventory testFrame = new CraftingInventory((Container)new ContainerNull(), 3, 3);
    private final ItemStack correctOutput;
    private final ICraftingRecipe standardRecipe;
    private final IAEItemStack[] condensedInputs;
    private final IAEItemStack[] condensedOutputs;
    private final IAEItemStack[] inputs;
    private final IAEItemStack[] outputs;
    private final boolean isCraftable;
    private final boolean canSubstitute;
    private final Set<TestLookup> failCache = new HashSet<TestLookup>();
    private final Set<TestLookup> passCache = new HashSet<TestLookup>();
    private final IAEItemStack pattern;
    private int priority = 0;

    public CraftingPatternDetails(IAEItemStack is, World w) {
        ItemStack gs;
        int x;
        Preconditions.checkArgument((boolean)(is.getItem() instanceof EncodedPatternItem), (Object)"itemStack is not a ICraftingPatternItem");
        EncodedPatternItem templateItem = (EncodedPatternItem)is.getItem();
        ItemStack itemStack = is.createItemStack();
        List<IAEItemStack> ingredients = templateItem.getIngredients(itemStack);
        List<IAEItemStack> products = templateItem.getProducts(itemStack);
        ResourceLocation recipeId = templateItem.getCraftingRecipeId(itemStack);
        this.pattern = is.copy();
        this.isCraftable = recipeId != null;
        this.canSubstitute = templateItem.allowsSubstitution(itemStack);
        ArrayList<IAEItemStack> in = new ArrayList<IAEItemStack>();
        ArrayList<Object> out = new ArrayList<Object>();
        for (x = 0; x < 9; ++x) {
            IAEItemStack iAEItemStack = ingredients.get(x);
            gs = iAEItemStack != null ? iAEItemStack.createItemStack() : ItemStack.field_190927_a;
            this.crafting.func_70299_a(x, gs);
            if (!gs.func_190926_b() && !this.isCraftable || !gs.func_77942_o()) {
                this.markItemAs(x, gs, TestStatus.ACCEPT);
            }
            in.add(iAEItemStack != null ? iAEItemStack.copy() : null);
            this.testFrame.func_70299_a(x, gs);
        }
        if (this.isCraftable) {
            IRecipe recipe = (IRecipe)w.func_199532_z().func_215366_a(IRecipeType.field_222149_a).get(recipeId);
            if (recipe == null || recipe.func_222127_g() != IRecipeType.field_222149_a) {
                throw new IllegalStateException("recipe id is not a crafting recipe");
            }
            this.standardRecipe = (ICraftingRecipe)recipe;
            this.correctOutput = this.standardRecipe.func_77572_b((IInventory)this.crafting);
            out.add(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(this.correctOutput));
        } else {
            this.standardRecipe = null;
            this.correctOutput = ItemStack.field_190927_a;
            for (x = 0; x < 3; ++x) {
                IAEItemStack iAEItemStack = products.get(x);
                gs = iAEItemStack.createItemStack();
                if (gs.func_190926_b()) continue;
                out.add(iAEItemStack.copy());
            }
        }
        this.inputs = in.toArray(new IAEItemStack[0]);
        this.outputs = out.toArray(new IAEItemStack[0]);
        HashMap<IAEItemStack, IAEItemStack> tmpOutputs = new HashMap<IAEItemStack, IAEItemStack>();
        for (IAEItemStack io : this.outputs) {
            if (io == null) continue;
            IAEItemStack g = (IAEItemStack)tmpOutputs.get(io);
            if (g == null) {
                tmpOutputs.put(io, io.copy());
                continue;
            }
            g.add(io);
        }
        HashMap<IAEItemStack, IAEItemStack> hashMap = new HashMap<IAEItemStack, IAEItemStack>();
        for (IAEItemStack io : this.inputs) {
            if (io == null) continue;
            IAEItemStack g = (IAEItemStack)hashMap.get(io);
            if (g == null) {
                hashMap.put(io, io.copy());
                continue;
            }
            g.add(io);
        }
        if (tmpOutputs.isEmpty() || hashMap.isEmpty()) {
            throw new IllegalStateException("No pattern here!");
        }
        this.condensedInputs = new IAEItemStack[hashMap.size()];
        int offset = 0;
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            IAEItemStack io;
            this.condensedInputs[offset] = io = (IAEItemStack)iterator.next();
            ++offset;
        }
        offset = 0;
        this.condensedOutputs = new IAEItemStack[tmpOutputs.size()];
        iterator = tmpOutputs.values().iterator();
        while (iterator.hasNext()) {
            IAEItemStack io;
            this.condensedOutputs[offset] = io = (IAEItemStack)iterator.next();
            ++offset;
        }
    }

    private void markItemAs(int slotIndex, ItemStack i, TestStatus b) {
        if (b == TestStatus.TEST || i.func_77942_o()) {
            return;
        }
        (b == TestStatus.ACCEPT ? this.passCache : this.failCache).add(new TestLookup(slotIndex, i));
    }

    @Override
    public ItemStack getPattern() {
        return this.pattern.createItemStack();
    }

    @Override
    public synchronized boolean isValidItemForSlot(int slotIndex, ItemStack i, World w) {
        if (!this.isCraftable) {
            throw new IllegalStateException("Only crafting recipes supported.");
        }
        TestStatus result = this.getStatus(slotIndex, i);
        switch (result) {
            case ACCEPT: {
                return true;
            }
            case DECLINE: {
                return false;
            }
        }
        for (int x = 0; x < this.crafting.func_70302_i_(); ++x) {
            this.testFrame.func_70299_a(x, this.crafting.func_70301_a(x));
        }
        this.testFrame.func_70299_a(slotIndex, i);
        if (!this.canSubstitute && slotIndex < this.inputs.length && !this.inputs[slotIndex].isSameType(i)) {
            this.markItemAs(slotIndex, i, TestStatus.DECLINE);
            return false;
        }
        if (this.standardRecipe.func_77569_a((IInventory)this.testFrame, w)) {
            ItemStack testOutput = this.standardRecipe.func_77572_b((IInventory)this.testFrame);
            if (Platform.itemComparisons().isSameItem(this.correctOutput, testOutput)) {
                this.testFrame.func_70299_a(slotIndex, this.crafting.func_70301_a(slotIndex));
                this.markItemAs(slotIndex, i, TestStatus.ACCEPT);
                return true;
            }
        }
        this.markItemAs(slotIndex, i, TestStatus.DECLINE);
        return false;
    }

    @Override
    public boolean isCraftable() {
        return this.isCraftable;
    }

    @Override
    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    @Override
    public IAEItemStack[] getCondensedInputs() {
        return this.condensedInputs;
    }

    @Override
    public IAEItemStack[] getCondensedOutputs() {
        return this.condensedOutputs;
    }

    @Override
    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    @Override
    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    @Override
    public ItemStack getOutput(CraftingInventory craftingInv, World w) {
        if (!this.isCraftable) {
            throw new IllegalStateException("Only crafting recipes supported.");
        }
        for (int x = 0; x < craftingInv.func_70302_i_(); ++x) {
            if (this.isValidItemForSlot(x, craftingInv.func_70301_a(x), w)) continue;
            return ItemStack.field_190927_a;
        }
        if (this.outputs != null && this.outputs.length > 0) {
            return this.outputs[0].createItemStack();
        }
        return ItemStack.field_190927_a;
    }

    private TestStatus getStatus(int slotIndex, ItemStack i) {
        if (this.crafting.func_70301_a(slotIndex).func_190926_b()) {
            return i.func_190926_b() ? TestStatus.ACCEPT : TestStatus.DECLINE;
        }
        if (i.func_190926_b()) {
            return TestStatus.DECLINE;
        }
        if (i.func_77942_o()) {
            return TestStatus.TEST;
        }
        if (this.passCache.contains(new TestLookup(slotIndex, i))) {
            return TestStatus.ACCEPT;
        }
        if (this.failCache.contains(new TestLookup(slotIndex, i))) {
            return TestStatus.DECLINE;
        }
        return TestStatus.TEST;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(CraftingPatternDetails o) {
        return Integer.compare(o.priority, this.priority);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftingPatternDetails other = (CraftingPatternDetails)obj;
        if (this.pattern != null && other.pattern != null) {
            return this.pattern.equals(other.pattern);
        }
        return false;
    }

    private static final class TestLookup {
        private final int slot;
        private final int ref;
        private final int hash;

        public TestLookup(int slot, ItemStack i) {
            this(slot, i.func_77973_b(), i.func_77952_i());
        }

        public TestLookup(int slot, Item item, int dmg) {
            this.slot = slot;
            this.ref = dmg << 16 | Item.func_150891_b((Item)item) & 0xFFFF;
            int offset = 3 * slot;
            this.hash = this.ref << offset | this.ref >> offset + 32;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            boolean equality;
            if (obj instanceof TestLookup) {
                TestLookup b = (TestLookup)obj;
                equality = b.slot == this.slot && b.ref == this.ref;
            } else {
                equality = false;
            }
            return equality;
        }
    }

    private static enum TestStatus {
        ACCEPT,
        DECLINE,
        TEST;

    }
}

