/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class InvalidPatternHelper {
    private final List<PatternIngredient> outputs = new ArrayList<PatternIngredient>();
    private final List<PatternIngredient> inputs = new ArrayList<PatternIngredient>();
    private final boolean isCrafting;
    private final boolean canSubstitute;

    public InvalidPatternHelper(ItemStack is) {
        int i;
        CompoundNBT encodedValue = is.func_77978_p();
        if (encodedValue == null) {
            throw new IllegalArgumentException("No pattern here!");
        }
        ListNBT inTag = encodedValue.func_150295_c("in", 10);
        ListNBT outTag = encodedValue.func_150295_c("out", 10);
        this.isCrafting = encodedValue.func_74767_n("crafting");
        this.canSubstitute = this.isCrafting && encodedValue.func_74767_n("substitute");
        for (i = 0; i < outTag.size(); ++i) {
            this.outputs.add(new PatternIngredient(outTag.func_150305_b(i)));
        }
        for (i = 0; i < inTag.size(); ++i) {
            CompoundNBT in = inTag.func_150305_b(i);
            if (in.isEmpty()) continue;
            this.inputs.add(new PatternIngredient(in));
        }
    }

    public List<PatternIngredient> getOutputs() {
        return this.outputs;
    }

    public List<PatternIngredient> getInputs() {
        return this.inputs;
    }

    public boolean isCraftable() {
        return this.isCrafting;
    }

    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    public class PatternIngredient {
        private String id;
        private int count;
        private int damage;
        private ItemStack stack;

        public PatternIngredient(CompoundNBT tag) {
            this.stack = ItemStack.func_199557_a((CompoundNBT)tag);
            if (this.stack.func_190926_b()) {
                this.id = tag.func_74779_i("id");
                this.count = tag.func_74771_c("Count");
                this.damage = Math.max(0, tag.func_74765_d("Damage"));
            }
        }

        public boolean isValid() {
            return !this.stack.func_190926_b();
        }

        public ITextComponent getName() {
            return this.isValid() ? Platform.getItemDisplayName(this.stack) : new StringTextComponent(this.id + '@' + this.getDamage());
        }

        public int getDamage() {
            return this.isValid() ? this.stack.func_77952_i() : this.damage;
        }

        public int getCount() {
            return this.isValid() ? this.stack.func_190916_E() : this.count;
        }

        public ItemStack getItem() {
            if (!this.isValid()) {
                throw new IllegalArgumentException("There is no valid ItemStack for this PatternIngredient");
            }
            return this.stack;
        }

        public ITextComponent getFormattedToolTip() {
            ITextComponent result = new StringTextComponent(this.getCount() + " ").func_150257_a(this.getName());
            if (!this.isValid()) {
                result.func_211708_a(TextFormatting.RED);
            }
            return result;
        }
    }
}

