/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.util.IOrientable;
import appeng.decorative.solid.QuartzPillarBlock;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MetaRotation
implements IOrientable {
    private final Property<Direction> facingProp;
    private final IBlockReader w;
    private final BlockPos pos;

    public MetaRotation(IBlockReader world, BlockPos pos, Property<Direction> facingProp) {
        this.w = world;
        this.pos = pos;
        this.facingProp = facingProp;
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public Direction getForward() {
        if (this.getUp().func_96559_d() == 0) {
            return Direction.UP;
        }
        return Direction.SOUTH;
    }

    @Override
    public Direction getUp() {
        BlockState state = this.w.func_180495_p(this.pos);
        if (this.facingProp != null && state.func_196959_b(this.facingProp)) {
            return (Direction)state.func_177229_b(this.facingProp);
        }
        if (state.func_196959_b(QuartzPillarBlock.AXIS)) {
            Direction.Axis a = (Direction.Axis)state.func_177229_b(QuartzPillarBlock.AXIS);
            switch (a) {
                case X: {
                    return Direction.EAST;
                }
                case Z: {
                    return Direction.SOUTH;
                }
            }
            return Direction.UP;
        }
        return Direction.UP;
    }

    @Override
    public void setOrientation(Direction forward, Direction up) {
        if (this.w instanceof World) {
            if (this.facingProp != null) {
                ((World)this.w).func_175656_a(this.pos, (BlockState)this.w.func_180495_p(this.pos).func_206870_a(this.facingProp, (Comparable)up));
            } else {
                ((World)this.w).func_175656_a(this.pos, (BlockState)this.w.func_180495_p(this.pos).func_206870_a(QuartzPillarBlock.AXIS, (Comparable)up.func_176740_k()));
            }
        } else {
            throw new IllegalStateException(this.w.getClass().getName() + " received, expected World");
        }
    }
}

