/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.implementations.items.IGrowableCrystal;
import appeng.core.localization.ButtonToolTips;
import appeng.entity.GrowingCrystalEntity;
import appeng.items.AEBaseItem;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CrystalSeedItem
extends AEBaseItem
implements IGrowableCrystal {
    private static final String TAG_GROWTH_TICKS = "p";
    private static final int GROWTH_TICKS_REQUIRED = 600;
    private final IItemProvider grownItem;

    public CrystalSeedItem(Item.Properties properties, IItemProvider grownItem) {
        super(properties);
        this.grownItem = (IItemProvider)Preconditions.checkNotNull((Object)grownItem);
        this.func_185043_a(new ResourceLocation("appliedenergistics2:growth"), (is, w, p) -> (float)CrystalSeedItem.getGrowthTicks(is) / 600.0f);
    }

    @Override
    @Nullable
    public ItemStack triggerGrowth(ItemStack is) {
        int growthTicks = CrystalSeedItem.getGrowthTicks(is) + 1;
        if (growthTicks >= 600) {
            return new ItemStack(this.grownItem, is.func_190916_E());
        }
        this.setGrowthTicks(is, growthTicks);
        return is;
    }

    private static int getGrowthTicks(ItemStack is) {
        CompoundNBT tag = is.func_77978_p();
        return tag != null ? tag.func_74762_e(TAG_GROWTH_TICKS) : 0;
    }

    private void setGrowthTicks(ItemStack is, int ticks) {
        ticks = MathHelper.func_76125_a((int)ticks, (int)0, (int)600);
        is.func_196082_o().func_74768_a(TAG_GROWTH_TICKS, ticks);
    }

    @Override
    public float getMultiplier(Block blk, Material mat) {
        return 0.5f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag advancedTooltips) {
        lines.add(ButtonToolTips.DoesntDespawn.getTranslationKey());
        lines.add(this.getGrowthTooltipItem(stack));
        super.func_77624_a(stack, world, lines, advancedTooltips);
    }

    public ITextComponent getGrowthTooltipItem(ItemStack stack) {
        int progress = CrystalSeedItem.getGrowthTicks(stack);
        return new StringTextComponent(Math.round((float)(100 * progress) / 600.0f) + "%");
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        GrowingCrystalEntity egc = new GrowingCrystalEntity(world, location.func_226277_ct_(), location.func_226278_cu_(), location.func_226281_cx_(), itemstack);
        egc.func_213317_d(location.func_213322_ci());
        egc.func_174867_a(40);
        return egc;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this, 1));
            ItemStack almostFullGrown = new ItemStack((IItemProvider)this, 1);
            this.setGrowthTicks(almostFullGrown, 599);
            items.add((Object)almostFullGrown);
        }
    }
}

