/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.exceptions.MissingDefinitionException;
import appeng.api.features.AEFeature;
import appeng.api.parts.IAlphaPassItem;
import appeng.api.util.AEPartLocation;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import appeng.items.AEBaseItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.registries.ForgeRegistries;

public class FacadeItem
extends AEBaseItem
implements IFacadeItem,
IAlphaPassItem {
    private static final ResourceLocation TAG_WHITELISTED = new ResourceLocation("appliedenergistics2", "whitelisted/facades");
    private static final String NBT_ITEM_ID = "item";

    public FacadeItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return Api.instance().partHelper().placeBus(stack, context.func_195995_a(), context.func_196000_l(), context.func_195999_j(), context.func_221531_n(), context.func_195991_k());
    }

    public ITextComponent func_200295_i(ItemStack is) {
        try {
            ItemStack in = this.getTextureItem(is);
            if (!in.func_190926_b()) {
                return super.func_200295_i(is).func_212638_h().func_150258_a(" - ").func_150257_a(in.func_200301_q());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.func_200295_i(is);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    public ItemStack createFacadeForItem(ItemStack itemStack, boolean returnItem) {
        boolean isBlockAllowed;
        if (itemStack.func_190926_b() || itemStack.func_77942_o() || !(itemStack.func_77973_b() instanceof BlockItem)) {
            return ItemStack.field_190927_a;
        }
        BlockItem blockItem = (BlockItem)itemStack.func_77973_b();
        Block block = blockItem.func_179223_d();
        if (block == Blocks.field_150350_a) {
            return ItemStack.field_190927_a;
        }
        BlockState blockState = block.func_176223_P();
        boolean areTileEntitiesEnabled = AEConfig.instance().isFeatureEnabled(AEFeature.TILE_ENTITY_FACADES);
        Tag whitelistTag = BlockTags.func_199896_a().func_199915_b(TAG_WHITELISTED);
        boolean isWhiteListed = block.func_203417_a(whitelistTag);
        boolean isModel = blockState.func_185901_i() == BlockRenderType.MODEL;
        BlockState defaultState = block.func_176223_P();
        boolean isTileEntity = block.hasTileEntity(defaultState);
        boolean isFullCube = defaultState.func_215686_e((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
        boolean isTileEntityAllowed = !isTileEntity || areTileEntitiesEnabled && isWhiteListed;
        boolean bl = isBlockAllowed = isFullCube || isWhiteListed;
        if (isModel && isTileEntityAllowed && isBlockAllowed) {
            if (returnItem) {
                return itemStack;
            }
            ItemStack is = new ItemStack((IItemProvider)this);
            CompoundNBT data = new CompoundNBT();
            data.func_74778_a(NBT_ITEM_ID, itemStack.func_77973_b().getRegistryName().toString());
            is.func_77982_d(data);
            return is;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public FacadePart createPartFromItemStack(ItemStack is, AEPartLocation side) {
        ItemStack in = this.getTextureItem(is);
        if (!in.func_190926_b()) {
            return new FacadePart(is, side);
        }
        return null;
    }

    @Override
    public ItemStack getTextureItem(ItemStack is) {
        CompoundNBT nbt = is.func_77978_p();
        if (nbt == null) {
            return ItemStack.field_190927_a;
        }
        ResourceLocation itemId = new ResourceLocation(nbt.func_74779_i(NBT_ITEM_ID));
        Item baseItem = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        if (baseItem == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)baseItem, 1);
    }

    @Override
    public BlockState getTextureBlockState(ItemStack is) {
        ItemStack baseItemStack = this.getTextureItem(is);
        if (baseItemStack.func_190926_b()) {
            return Blocks.field_150359_w.func_176223_P();
        }
        Block block = Block.func_149634_a((Item)baseItemStack.func_77973_b());
        if (block == Blocks.field_150350_a) {
            return Blocks.field_150359_w.func_176223_P();
        }
        return block.func_176223_P();
    }

    public ItemStack createFromID(int id) {
        ItemStack facadeStack = Api.instance().definitions().items().facade().maybeStack(1).orElseThrow(() -> new MissingDefinitionException("Tried to create a facade, while facades are being deactivated."));
        Item item = (Item)Registry.field_212630_s.func_148745_a(id);
        if (item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        CompoundNBT facadeTag = new CompoundNBT();
        facadeTag.func_74778_a(NBT_ITEM_ID, item.getRegistryName().toString());
        facadeStack.func_77982_d(facadeTag);
        return facadeStack;
    }

    @Override
    public boolean useAlphaPass(ItemStack is) {
        BlockState blockState = this.getTextureBlockState(is);
        if (blockState == null) {
            return false;
        }
        return RenderTypeLookup.canRenderInLayer((BlockState)blockState, (RenderType)RenderType.func_228645_f_()) || RenderTypeLookup.canRenderInLayer((BlockState)blockState, (RenderType)RenderType.func_228647_g_());
    }
}

