/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.implementations.TransitionResult;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.storage.ISpatialDimension;
import appeng.api.util.WorldCoord;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.spatial.SpatialDimensionManager;
import appeng.spatial.StorageHelper;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpatialStorageCellItem
extends AEBaseItem
implements ISpatialStorageCell {
    private static final String TAG_DIMENSION_ID = "dimension_id";
    private final int maxRegion;

    public SpatialStorageCellItem(Item.Properties props, int spatialScale) {
        super(props);
        this.maxRegion = spatialScale;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag advancedTooltips) {
        DimensionType dimType = this.getStoredDimension(stack);
        if (dimType == null) {
            lines.add(GuiText.Unformatted.textComponent().func_211708_a(TextFormatting.ITALIC));
            lines.add(GuiText.SpatialCapacity.textComponent(this.maxRegion, this.maxRegion, this.maxRegion));
        } else {
            SpatialDimensionManager.INSTANCE.addCellDimensionTooltip(dimType, lines);
        }
        if (advancedTooltips.func_194127_a() && dimType != null && dimType.getRegistryName() != null) {
            lines.add((ITextComponent)new StringTextComponent("Dimension: " + dimType.getRegistryName()));
        }
    }

    @Override
    public boolean isSpatialStorage(ItemStack is) {
        return true;
    }

    @Override
    public int getMaxStoredDim(ItemStack is) {
        return this.maxRegion;
    }

    @Override
    public DimensionType getStoredDimension(ItemStack is) {
        CompoundNBT c = is.func_77978_p();
        if (c != null && c.func_74764_b(TAG_DIMENSION_ID)) {
            try {
                ResourceLocation dimTypeId = new ResourceLocation(c.func_74779_i(TAG_DIMENSION_ID));
                return DimensionType.func_193417_a((ResourceLocation)dimTypeId);
            }
            catch (Exception e) {
                AELog.warn("Failed to retrieve storage cell dimension.", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransitionResult doSpatialTransition(ItemStack is, World w, WorldCoord min, WorldCoord max, int playerId) {
        int targetX = max.x - min.x - 1;
        int targetY = max.y - min.y - 1;
        int targetZ = max.z - min.z - 1;
        int maxSize = this.getMaxStoredDim(is);
        BlockPos targetSize = new BlockPos(targetX, targetY, targetZ);
        ISpatialDimension manager = SpatialDimensionManager.INSTANCE;
        DimensionType storedDim = this.getStoredDimension(is);
        if (storedDim == null) {
            storedDim = manager.createNewCellDimension(targetSize);
        }
        if (storedDim == null) {
            return new TransitionResult(false, 0.0);
        }
        try {
            if (manager.isCellDimension(storedDim)) {
                ServerWorld cellWorld = manager.getWorld(storedDim);
                BlockPos scale = manager.getCellDimensionSize(storedDim);
                if (scale.equals((Object)targetSize) && targetX <= maxSize && targetY <= maxSize && targetZ <= maxSize) {
                    BlockPos offset = manager.getCellDimensionOrigin(storedDim);
                    this.setStoredDimension(is, storedDim);
                    StorageHelper.getInstance().swapRegions(w, min.x + 1, min.y + 1, min.z + 1, (World)cellWorld, offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p(), targetX - 1, targetY - 1, targetZ - 1);
                    TransitionResult transitionResult = new TransitionResult(true, 0.0);
                    return transitionResult;
                }
            }
            TransitionResult transitionResult = new TransitionResult(false, 0.0);
            return transitionResult;
        }
        finally {
            if (manager.isCellDimension(storedDim) && this.getStoredDimension(is) == null) {
                manager.deleteCellDimension(storedDim);
            }
        }
    }

    private void setStoredDimension(ItemStack is, DimensionType dim) {
        CompoundNBT c = is.func_196082_o();
        c.func_74778_a(TAG_DIMENSION_ID, dim.getRegistryName().toString());
    }
}

