/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Upgrades;
import appeng.api.features.AEFeature;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.MatterCannonPacket;
import appeng.hooks.TickHandler;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.misc.PaintBallItem;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.helpers.PlayerSource;
import appeng.tile.misc.PaintSplotchesTileEntity;
import appeng.util.LookDirection;
import appeng.util.Platform;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;

public class MatterCannonItem
extends AEBasePoweredItem
implements IStorageCell<IAEItemStack> {
    private static final int ENERGY_PER_SHOT = 1600;

    public MatterCannonItem(Item.Properties props) {
        super(AEConfig.instance().getMatterCannonBattery(), props);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag advancedTooltips) {
        super.func_77624_a(stack, world, lines, advancedTooltips);
        ICellInventoryHandler<IAEItemStack> cdi = Api.instance().registries().cell().getCellInventory(stack, null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        Api.instance().client().addCellInformation(cdi, lines);
    }

    public ActionResult<ItemStack> func_77659_a(World w, PlayerEntity p, @Nullable Hand hand) {
        if (this.getAECurrentPower(p.func_184586_b(hand)) > 1600.0) {
            ICellInventoryHandler<IAEItemStack> inv;
            int shots = 1;
            CellUpgrades cu = (CellUpgrades)this.getUpgradesInventory(p.func_184586_b(hand));
            if (cu != null) {
                shots += cu.getInstalledUpgrades(Upgrades.SPEED);
            }
            if ((inv = Api.instance().registries().cell().getCellInventory(p.func_184586_b(hand), null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class))) != null) {
                IItemList itemList = inv.getAvailableItems(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList());
                IAEItemStack req = (IAEItemStack)itemList.getFirstItem();
                if (req instanceof IAEItemStack) {
                    shots = Math.min(shots, (int)req.getStackSize());
                    for (int sh = 0; sh < shots; ++sh) {
                        IAEItemStack aeAmmo = req.copy();
                        this.extractAEPower(p.func_184586_b(hand), 1600.0, Actionable.MODULATE);
                        if (Platform.isClient()) {
                            return new ActionResult(ActionResultType.SUCCESS, (Object)p.func_184586_b(hand));
                        }
                        aeAmmo.setStackSize(1L);
                        ItemStack ammo = aeAmmo.createItemStack();
                        if (ammo.func_190926_b()) {
                            return new ActionResult(ActionResultType.SUCCESS, (Object)p.func_184586_b(hand));
                        }
                        if ((aeAmmo = inv.extractItems(aeAmmo, Actionable.MODULATE, new PlayerSource(p, null))) == null) {
                            return new ActionResult(ActionResultType.SUCCESS, (Object)p.func_184586_b(hand));
                        }
                        LookDirection dir = Platform.getPlayerRay(p, 32.0);
                        Vec3d rayFrom = dir.getA();
                        Vec3d rayTo = dir.getB();
                        Vec3d direction = rayTo.func_178788_d(rayFrom);
                        direction.func_72432_b();
                        double d0 = rayFrom.field_72450_a;
                        double d1 = rayFrom.field_72448_b;
                        double d2 = rayFrom.field_72449_c;
                        float penetration = Api.instance().registries().matterCannon().getPenetration(ammo);
                        if (penetration <= 0.0f) {
                            ItemStack type = aeAmmo.asItemStackRepresentation();
                            if (type.func_77973_b() instanceof PaintBallItem) {
                                this.shootPaintBalls(type, w, p, rayFrom, rayTo, direction, d0, d1, d2);
                            }
                            return new ActionResult(ActionResultType.SUCCESS, (Object)p.func_184586_b(hand));
                        }
                        this.standardAmmo(penetration, w, p, rayFrom, rayTo, direction, d0, d1, d2);
                    }
                } else {
                    if (Platform.isServer()) {
                        p.func_145747_a(PlayerMessages.AmmoDepleted.get());
                    }
                    return new ActionResult(ActionResultType.SUCCESS, (Object)p.func_184586_b(hand));
                }
            }
        }
        return new ActionResult(ActionResultType.FAIL, (Object)p.func_184586_b(hand));
    }

    private void shootPaintBalls(ItemStack type, World w, PlayerEntity p, Vec3d Vec3d2, Vec3d Vec3d1, Vec3d direction, double d0, double d1, double d2) {
        AxisAlignedBB bb = new AxisAlignedBB(Math.min(Vec3d2.field_72450_a, Vec3d1.field_72450_a), Math.min(Vec3d2.field_72448_b, Vec3d1.field_72448_b), Math.min(Vec3d2.field_72449_c, Vec3d1.field_72449_c), Math.max(Vec3d2.field_72450_a, Vec3d1.field_72450_a), Math.max(Vec3d2.field_72448_b, Vec3d1.field_72448_b), Math.max(Vec3d2.field_72449_c, Vec3d1.field_72449_c)).func_72314_b(16.0, 16.0, 16.0);
        Entity entity = null;
        Vec3d entityIntersection = null;
        List list = w.func_72839_b((Entity)p, bb);
        double closest = 9999999.0;
        for (int l = 0; l < list.size(); ++l) {
            double nd;
            Entity entity1 = (Entity)list.get(l);
            if (entity1.func_70089_S() || entity1 == p || entity1 instanceof ItemEntity || !entity1.func_70089_S() || entity1.func_184215_y((Entity)p)) continue;
            float f1 = 0.3f;
            AxisAlignedBB boundingBox = entity1.func_174813_aQ().func_72314_b((double)0.3f, (double)0.3f, (double)0.3f);
            Vec3d intersection = boundingBox.func_216365_b(Vec3d2, Vec3d1).orElse(null);
            if (intersection == null || !((nd = Vec3d2.func_72436_e(intersection)) < closest)) continue;
            entity = entity1;
            entityIntersection = intersection;
            closest = nd;
        }
        RayTraceContext rayTraceContext = new RayTraceContext(Vec3d2, Vec3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)p);
        BlockRayTraceResult pos = w.func_217299_a(rayTraceContext);
        Vec3d vec = new Vec3d(d0, d1, d2);
        if (entity != null && pos.func_216346_c() != RayTraceResult.Type.MISS && pos.func_216347_e().func_72436_e(vec) > closest) {
            pos = new EntityRayTraceResult(entity, entityIntersection);
        } else if (entity != null && pos.func_216346_c() == RayTraceResult.Type.MISS) {
            pos = new EntityRayTraceResult(entity, entityIntersection);
        }
        try {
            AppEng.proxy.sendToAllNearExcept(null, d0, d1, d2, 128.0, w, new MatterCannonPacket(d0, d1, d2, (float)direction.field_72450_a, (float)direction.field_72448_b, (float)direction.field_72449_c, (byte)(pos.func_216346_c() == RayTraceResult.Type.MISS ? 32.0 : pos.func_216347_e().func_72436_e(vec) + 1.0)));
        }
        catch (Exception err) {
            AELog.debug(err);
        }
        if (pos.func_216346_c() != RayTraceResult.Type.MISS && type != null && type.func_77973_b() instanceof PaintBallItem) {
            PaintBallItem ipb = (PaintBallItem)type.func_77973_b();
            AEColor col = ipb.getColor();
            if (pos instanceof EntityRayTraceResult) {
                EntityRayTraceResult entityResult = (EntityRayTraceResult)pos;
                Entity entityHit = entityResult.func_216348_a();
                int id = entityHit.func_145782_y();
                TickHandler.PlayerColor marker = new TickHandler.PlayerColor(id, col, 600);
                TickHandler.INSTANCE.getPlayerColors().put(id, marker);
                if (entityHit instanceof SheepEntity) {
                    SheepEntity sh = (SheepEntity)entityHit;
                    sh.func_175512_b(col.dye);
                }
                entityHit.func_70097_a(DamageSource.func_76365_a((PlayerEntity)p), 0.0f);
                NetworkHandler.instance().sendToAll(marker.getPacket());
            } else if (pos instanceof BlockRayTraceResult) {
                TileEntity te;
                BlockRayTraceResult blockResult = pos;
                Direction side = blockResult.func_216354_b();
                BlockPos hitPos = blockResult.func_216350_a().func_177972_a(side);
                if (!Platform.hasPermissions(new DimensionalCoord((IWorld)w, hitPos), p)) {
                    return;
                }
                BlockState whatsThere = w.func_180495_p(hitPos);
                if (whatsThere.func_185904_a().func_76222_j() && w.func_175623_d(hitPos)) {
                    Api.instance().definitions().blocks().paint().maybeBlock().ifPresent(paintBlock -> w.func_180501_a(hitPos, paintBlock.func_176223_P(), 3));
                }
                if ((te = w.func_175625_s(hitPos)) instanceof PaintSplotchesTileEntity) {
                    Vec3d hp = pos.func_216347_e().func_178786_a((double)hitPos.func_177958_n(), (double)hitPos.func_177956_o(), (double)hitPos.func_177952_p());
                    ((PaintSplotchesTileEntity)te).addBlot(type, side.func_176734_d(), hp);
                }
            }
        }
    }

    private void standardAmmo(float penetration, World w, PlayerEntity p, Vec3d Vec3d2, Vec3d Vec3d1, Vec3d direction, double d0, double d1, double d2) {
        boolean hasDestroyed = true;
        while (penetration > 0.0f && hasDestroyed) {
            hasDestroyed = false;
            AxisAlignedBB bb = new AxisAlignedBB(Math.min(Vec3d2.field_72450_a, Vec3d1.field_72450_a), Math.min(Vec3d2.field_72448_b, Vec3d1.field_72448_b), Math.min(Vec3d2.field_72449_c, Vec3d1.field_72449_c), Math.max(Vec3d2.field_72450_a, Vec3d1.field_72450_a), Math.max(Vec3d2.field_72448_b, Vec3d1.field_72448_b), Math.max(Vec3d2.field_72449_c, Vec3d1.field_72449_c)).func_72314_b(16.0, 16.0, 16.0);
            Entity entity = null;
            Vec3d entityIntersection = null;
            List list = w.func_72839_b((Entity)p, bb);
            double closest = 9999999.0;
            for (int l = 0; l < list.size(); ++l) {
                double nd;
                Entity entity1 = (Entity)list.get(l);
                if (!entity1.func_70089_S() || entity1 == p || entity1 instanceof ItemEntity || !entity1.func_70089_S() || entity1.func_184215_y((Entity)p)) continue;
                float f1 = 0.3f;
                AxisAlignedBB boundingBox = entity1.func_174813_aQ().func_72314_b((double)0.3f, (double)0.3f, (double)0.3f);
                Vec3d intersection = boundingBox.func_216365_b(Vec3d2, Vec3d1).orElse(null);
                if (intersection == null || !((nd = Vec3d2.func_72436_e(intersection)) < closest)) continue;
                entity = entity1;
                entityIntersection = intersection;
                closest = nd;
            }
            RayTraceContext rayTraceContext = new RayTraceContext(Vec3d2, Vec3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)p);
            Vec3d vec = new Vec3d(d0, d1, d2);
            BlockRayTraceResult pos = w.func_217299_a(rayTraceContext);
            if (entity != null && pos.func_216346_c() != RayTraceResult.Type.MISS && pos.func_216347_e().func_72436_e(vec) > closest) {
                pos = new EntityRayTraceResult(entity, entityIntersection);
            } else if (entity != null && pos.func_216346_c() == RayTraceResult.Type.MISS) {
                pos = new EntityRayTraceResult(entity, entityIntersection);
            }
            try {
                AppEng.proxy.sendToAllNearExcept(null, d0, d1, d2, 128.0, w, new MatterCannonPacket(d0, d1, d2, (float)direction.field_72450_a, (float)direction.field_72448_b, (float)direction.field_72449_c, (byte)(pos.func_216346_c() == RayTraceResult.Type.MISS ? 32.0 : pos.func_216347_e().func_72436_e(vec) + 1.0)));
            }
            catch (Exception err) {
                AELog.debug(err);
            }
            if (pos.func_216346_c() == RayTraceResult.Type.MISS) continue;
            EntityDamageSource dmgSrc = new EntityDamageSource("matter_cannon", (Entity)p);
            if (pos instanceof EntityRayTraceResult) {
                EntityRayTraceResult entityResult = (EntityRayTraceResult)pos;
                Entity entityHit = entityResult.func_216348_a();
                int dmg = (int)Math.ceil(penetration / 20.0f);
                if (entityHit instanceof LivingEntity) {
                    LivingEntity el = (LivingEntity)entityHit;
                    penetration -= (float)dmg;
                    el.func_70653_a((Entity)p, 0.0f, -direction.field_72450_a, -direction.field_72449_c);
                    el.func_70097_a((DamageSource)dmgSrc, (float)dmg);
                    if (el.func_70089_S()) continue;
                    hasDestroyed = true;
                    continue;
                }
                if (entityHit instanceof ItemEntity) {
                    hasDestroyed = true;
                    entityHit.func_70106_y();
                    continue;
                }
                if (!entityHit.func_70097_a((DamageSource)dmgSrc, (float)dmg)) continue;
                hasDestroyed = true;
                continue;
            }
            if (!(pos instanceof BlockRayTraceResult)) continue;
            BlockRayTraceResult blockResult = pos;
            if (!AEConfig.instance().isFeatureEnabled(AEFeature.MASS_CANNON_BLOCK_DAMAGE)) {
                penetration = 0.0f;
                continue;
            }
            BlockPos blockPos = blockResult.func_216350_a();
            BlockState bs = w.func_180495_p(blockPos);
            float hardness = bs.func_185887_b((IBlockReader)w, blockPos) * 9.0f;
            if (!((double)hardness >= 0.0) || !(penetration > hardness) || !Platform.hasPermissions(new DimensionalCoord((IWorld)w, blockPos), p)) continue;
            hasDestroyed = true;
            penetration -= hardness;
            penetration = (float)((double)penetration * 0.6);
            w.func_175655_b(blockPos, true);
        }
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 4);
    }

    @Override
    public IItemHandler getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = is.func_196082_o().func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        is.func_196082_o().func_74778_a("FuzzyMode", fzMode.name());
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return 512;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 1;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        float pen = Api.instance().registries().matterCannon().getPenetration(requestedAddition.createItemStack());
        if (pen > 0.0f) {
            return false;
        }
        return !(requestedAddition.getItem() instanceof PaintBallItem);
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }
}

