/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.crafting.ICraftingHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCraftingCpuChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.WorldCoord;
import appeng.container.ContainerNull;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.crafting.CraftBranchFailure;
import appeng.crafting.CraftingJob;
import appeng.crafting.CraftingLink;
import appeng.crafting.CraftingWatcher;
import appeng.crafting.MECraftingInventory;
import appeng.me.cache.CraftingGridCache;
import appeng.me.cluster.IAECluster;
import appeng.me.helpers.MachineSource;
import appeng.tile.crafting.CraftingMonitorTileEntity;
import appeng.tile.crafting.CraftingTileEntity;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public final class CraftingCPUCluster
implements IAECluster,
ICraftingCPU {
    private static final String LOG_MARK_AS_COMPLETE = "Completed job for %s.";
    private final WorldCoord min;
    private final WorldCoord max;
    private final int[] usedOps = new int[3];
    private final Map<ICraftingPatternDetails, TaskProgress> tasks = new HashMap<ICraftingPatternDetails, TaskProgress>();
    private final List<CraftingTileEntity> tiles = new ArrayList<CraftingTileEntity>();
    private final List<CraftingTileEntity> storage = new ArrayList<CraftingTileEntity>();
    private final List<CraftingMonitorTileEntity> status = new ArrayList<CraftingMonitorTileEntity>();
    private final HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new HashMap();
    private ICraftingLink myLastLink;
    private ITextComponent myName = null;
    private boolean isDestroyed = false;
    private MECraftingInventory inventory = new MECraftingInventory();
    private IAEItemStack finalOutput;
    private boolean waiting = false;
    private IItemList<IAEItemStack> waitingFor = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private long availableStorage = 0L;
    private MachineSource machineSrc = null;
    private int accelerator = 0;
    private boolean isComplete = true;
    private int remainingOperations;
    private boolean somethingChanged;
    private long lastTime;
    private long elapsedTime;
    private long startItemCount;
    private long remainingItemCount;

    public CraftingCPUCluster(WorldCoord min, WorldCoord max) {
        this.min = min;
        this.max = max;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public ICraftingLink getLastCraftingLink() {
        return this.myLastLink;
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        this.listeners.remove(l);
    }

    public IMEInventory<IAEItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public void updateStatus(boolean updateGrid) {
        for (CraftingTileEntity r : this.tiles) {
            r.updateMeta(true);
        }
    }

    @Override
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        boolean posted = false;
        for (CraftingTileEntity r : this.tiles) {
            IGrid g;
            IGridNode n = r.getActionableNode();
            if (n != null && !posted && (g = n.getGrid()) != null) {
                g.postEvent(new MENetworkCraftingCpuChange(n));
                posted = true;
            }
            r.updateStatus(null);
        }
    }

    @Override
    public Iterator<IGridHost> getTiles() {
        return this.tiles.iterator();
    }

    void addTile(CraftingTileEntity te) {
        if (this.machineSrc == null || te.isCoreBlock()) {
            this.machineSrc = new MachineSource(te);
        }
        te.setCoreBlock(false);
        te.saveChanges();
        this.tiles.add(0, te);
        if (te.isStorage()) {
            this.availableStorage += (long)te.getStorageBytes();
            this.storage.add(te);
        } else if (te.isStatus()) {
            this.status.add((CraftingMonitorTileEntity)te);
        } else if (te.isAccelerator()) {
            ++this.accelerator;
        }
    }

    public boolean canAccept(IAEItemStack input) {
        IAEItemStack is;
        return input instanceof IAEItemStack && (is = this.waitingFor.findPrecise(input)) != null && is.getStackSize() > 0L;
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
        if (!(input instanceof IAEItemStack)) {
            return input;
        }
        IAEItemStack what = input.copy();
        IAEItemStack is = this.waitingFor.findPrecise(what);
        if (type == Actionable.SIMULATE) {
            if (is != null && is.getStackSize() > 0L) {
                if (is.getStackSize() >= what.getStackSize()) {
                    if (this.finalOutput.equals(what)) {
                        if (this.myLastLink != null) {
                            return ((CraftingLink)this.myLastLink).injectItems(what.copy(), type);
                        }
                        return what;
                    }
                    return null;
                }
                IAEItemStack leftOver = what.copy();
                leftOver.decStackSize(is.getStackSize());
                IAEItemStack used = what.copy();
                used.setStackSize(is.getStackSize());
                if (this.finalOutput.equals(what)) {
                    if (this.myLastLink != null) {
                        leftOver.add(((CraftingLink)this.myLastLink).injectItems(used.copy(), type));
                        return leftOver;
                    }
                    return what;
                }
                return leftOver;
            }
        } else if (type == Actionable.MODULATE && is != null && is.getStackSize() > 0L) {
            this.waiting = false;
            this.postChange(what, src);
            if (is.getStackSize() >= what.getStackSize()) {
                is.decStackSize(what.getStackSize());
                this.updateElapsedTime(what);
                this.markDirty();
                this.postCraftingStatusChange((IAEItemStack)what.copy().setStackSize(-what.getStackSize()));
                if (this.finalOutput.equals(what)) {
                    IAEItemStack leftover = what;
                    this.finalOutput.decStackSize(what.getStackSize());
                    if (this.myLastLink != null) {
                        leftover = ((CraftingLink)this.myLastLink).injectItems(what, type);
                    }
                    if (this.finalOutput.getStackSize() <= 0L) {
                        this.completeJob();
                    }
                    this.updateCPU();
                    return leftover;
                }
                return this.inventory.injectItems(what, type, src);
            }
            IAEItemStack insert = what.copy();
            insert.setStackSize(is.getStackSize());
            what.decStackSize(is.getStackSize());
            is.setStackSize(0L);
            this.postCraftingStatusChange((IAEItemStack)insert.copy().setStackSize(-insert.getStackSize()));
            if (this.finalOutput.equals(insert)) {
                IAEItemStack leftover = input;
                this.finalOutput.decStackSize(insert.getStackSize());
                if (this.myLastLink != null) {
                    what.add(((CraftingLink)this.myLastLink).injectItems(insert.copy(), type));
                    leftover = what;
                }
                if (this.finalOutput.getStackSize() <= 0L) {
                    this.completeJob();
                }
                this.updateCPU();
                this.markDirty();
                return leftover;
            }
            this.inventory.injectItems(insert, type, src);
            this.markDirty();
            return what;
        }
        return input;
    }

    private void postChange(IAEItemStack diff, IActionSource src) {
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> i = this.getListeners();
        if (i.hasNext()) {
            ImmutableList single = ImmutableList.of((Object)diff.copy());
            while (i.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> o = i.next();
                IMEMonitorHandlerReceiver<IAEItemStack> receiver = o.getKey();
                if (receiver.isValid(o.getValue())) {
                    receiver.postChange(null, (Iterable<IAEItemStack>)single, src);
                    continue;
                }
                i.remove();
            }
        }
    }

    private void markDirty() {
        this.getCore().saveChanges();
    }

    private void postCraftingStatusChange(IAEItemStack diff) {
        Collection<CraftingWatcher> list;
        if (this.getGrid() == null) {
            return;
        }
        CraftingGridCache sg = (CraftingGridCache)this.getGrid().getCache(ICraftingGrid.class);
        if (sg.getInterestManager().containsKey(diff) && !(list = sg.getInterestManager().get(diff)).isEmpty()) {
            for (CraftingWatcher iw : list) {
                iw.getHost().onRequestChange(sg, diff);
            }
        }
    }

    private void completeJob() {
        if (this.myLastLink != null) {
            ((CraftingLink)this.myLastLink).markDone();
        }
        if (AELog.isCraftingLogEnabled()) {
            IAEItemStack logStack = this.finalOutput.copy();
            logStack.setStackSize(this.startItemCount);
            AELog.crafting(LOG_MARK_AS_COMPLETE, logStack);
        }
        this.remainingItemCount = 0L;
        this.startItemCount = 0L;
        this.lastTime = 0L;
        this.elapsedTime = 0L;
        this.isComplete = true;
    }

    private void updateCPU() {
        IAEItemStack send = this.finalOutput;
        if (this.finalOutput != null && this.finalOutput.getStackSize() <= 0L) {
            send = null;
        }
        for (CraftingMonitorTileEntity t : this.status) {
            t.setJob(send);
        }
    }

    private Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> getListeners() {
        return this.listeners.entrySet().iterator();
    }

    private CraftingTileEntity getCore() {
        if (this.machineSrc == null) {
            return null;
        }
        return (CraftingTileEntity)this.machineSrc.machine().get();
    }

    private IGrid getGrid() {
        for (CraftingTileEntity r : this.tiles) {
            IGrid g;
            IGridNode gn = r.getActionableNode();
            if (gn == null || (g = gn.getGrid()) == null) continue;
            return r.getActionableNode().getGrid();
        }
        return null;
    }

    private boolean canCraft(ICraftingPatternDetails details, IAEItemStack[] condensedInputs) {
        for (IAEItemStack g : condensedInputs) {
            ItemStack is;
            if (details.isCraftable()) {
                boolean found = false;
                for (IAEItemStack fuzz : this.inventory.getItemList().findFuzzy(g, FuzzyMode.IGNORE_ALL)) {
                    ItemStack is2;
                    fuzz = fuzz.copy();
                    fuzz.setStackSize(g.getStackSize());
                    IAEItemStack ais = this.inventory.extractItems(fuzz, Actionable.SIMULATE, (IActionSource)this.machineSrc);
                    ItemStack itemStack = is2 = ais == null ? ItemStack.field_190927_a : ais.createItemStack();
                    if (!is2.func_190926_b() && (long)is2.func_190916_E() == g.getStackSize()) {
                        found = true;
                        break;
                    }
                    if (is2.func_190926_b()) continue;
                    g = g.copy();
                    g.decStackSize(is2.func_190916_E());
                }
                if (found) continue;
                return false;
            }
            IAEItemStack ais = this.inventory.extractItems(g.copy(), Actionable.SIMULATE, (IActionSource)this.machineSrc);
            ItemStack itemStack = is = ais == null ? ItemStack.field_190927_a : ais.createItemStack();
            if (!is.func_190926_b() && (long)is.func_190916_E() >= g.getStackSize()) continue;
            return false;
        }
        return true;
    }

    public void cancel() {
        if (this.myLastLink != null) {
            this.myLastLink.cancel();
        }
        IItemList<IAEItemStack> list = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        this.getListOfItem(list, CraftingItemList.ALL);
        for (IAEItemStack is : list) {
            this.postChange(is, this.machineSrc);
        }
        this.isComplete = true;
        this.myLastLink = null;
        this.tasks.clear();
        ArrayList items = new ArrayList(this.waitingFor.size());
        this.waitingFor.forEach(stack -> items.add(stack.copy().setStackSize(-stack.getStackSize())));
        this.waitingFor.resetStatus();
        for (IAEItemStack is : items) {
            this.postCraftingStatusChange(is);
        }
        this.finalOutput = null;
        this.updateCPU();
        this.storeItems();
    }

    public void updateCraftingLogic(IGrid grid, IEnergyGrid eg, CraftingGridCache cc) {
        if (!this.getCore().isActive()) {
            return;
        }
        if (this.myLastLink != null && this.myLastLink.isCanceled()) {
            this.myLastLink = null;
            this.cancel();
        }
        if (this.isComplete) {
            if (this.inventory.getItemList().isEmpty()) {
                return;
            }
            this.storeItems();
            return;
        }
        this.waiting = false;
        if (this.waiting || this.tasks.isEmpty()) {
            return;
        }
        int started = this.remainingOperations = this.accelerator + 1 - (this.usedOps[0] + this.usedOps[1] + this.usedOps[2]);
        if (this.remainingOperations > 0) {
            do {
                this.somethingChanged = false;
                this.executeCrafting(eg, cc);
            } while (this.somethingChanged && this.remainingOperations > 0);
        }
        this.usedOps[2] = this.usedOps[1];
        this.usedOps[1] = this.usedOps[0];
        this.usedOps[0] = started - this.remainingOperations;
        if (this.remainingOperations > 0 && !this.somethingChanged) {
            this.waiting = true;
        }
    }

    private void executeCrafting(IEnergyGrid eg, CraftingGridCache cc) {
        Iterator<Map.Entry<ICraftingPatternDetails, TaskProgress>> i = this.tasks.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<ICraftingPatternDetails, TaskProgress> e = i.next();
            if (e.getValue().value <= 0L) {
                i.remove();
                continue;
            }
            ICraftingPatternDetails details = e.getKey();
            if (!this.canCraft(details, details.getCondensedInputs())) continue;
            CraftingInventory ic = null;
            for (ICraftingMedium m : cc.getMediums(e.getKey())) {
                if (e.getValue().value <= 0L || m.isBusy()) continue;
                if (ic == null) {
                    int x;
                    IAEItemStack[] input = details.getInputs();
                    double sum = 0.0;
                    for (IAEItemStack anInput : input) {
                        if (anInput == null) continue;
                        sum += (double)anInput.getStackSize();
                    }
                    if (eg.extractAEPower(sum, Actionable.MODULATE, PowerMultiplier.CONFIG) < sum - 0.01) continue;
                    ic = new CraftingInventory((Container)new ContainerNull(), 3, 3);
                    boolean found = false;
                    for (x = 0; x < input.length; ++x) {
                        if (input[x] == null) continue;
                        found = false;
                        if (details.isCraftable()) {
                            Collection<Object> itemList;
                            if (details.canSubstitute()) {
                                itemList = this.inventory.getItemList().findFuzzy(input[x], FuzzyMode.IGNORE_ALL);
                            } else {
                                itemList = new ArrayList(1);
                                IAEItemStack item = this.inventory.getItemList().findPrecise(input[x]);
                                if (item != null) {
                                    itemList.add(item);
                                }
                            }
                            for (IAEItemStack iAEItemStack : itemList) {
                                IAEItemStack ais;
                                ItemStack is;
                                IAEItemStack iAEItemStack2 = iAEItemStack.copy();
                                iAEItemStack2.setStackSize(input[x].getStackSize());
                                if (!details.isValidItemForSlot(x, iAEItemStack2.createItemStack(), this.getWorld()) || (is = (ais = this.inventory.extractItems(iAEItemStack2, Actionable.MODULATE, (IActionSource)this.machineSrc)) == null ? ItemStack.field_190927_a : ais.createItemStack()).func_190926_b()) continue;
                                this.postChange(AEItemStack.fromItemStack(is), this.machineSrc);
                                ic.func_70299_a(x, is);
                                found = true;
                                break;
                            }
                        } else {
                            ItemStack is;
                            IAEItemStack ais = this.inventory.extractItems(input[x].copy(), Actionable.MODULATE, (IActionSource)this.machineSrc);
                            ItemStack itemStack = is = ais == null ? ItemStack.field_190927_a : ais.createItemStack();
                            if (!is.func_190926_b()) {
                                this.postChange(input[x], this.machineSrc);
                                ic.func_70299_a(x, is);
                                if ((long)is.func_190916_E() == input[x].getStackSize()) {
                                    found = true;
                                    continue;
                                }
                            }
                        }
                        if (!found) break;
                    }
                    if (!found) {
                        for (x = 0; x < ic.func_70302_i_(); ++x) {
                            ItemStack is = ic.func_70301_a(x);
                            if (is.func_190926_b()) continue;
                            this.inventory.injectItems(AEItemStack.fromItemStack(is), Actionable.MODULATE, (IActionSource)this.machineSrc);
                        }
                        ic = null;
                        break;
                    }
                }
                if (!m.pushPattern(details, ic)) continue;
                this.somethingChanged = true;
                --this.remainingOperations;
                for (IAEItemStack out : details.getCondensedOutputs()) {
                    this.postChange(out, this.machineSrc);
                    this.waitingFor.add(out.copy());
                    this.postCraftingStatusChange(out.copy());
                }
                if (details.isCraftable()) {
                    BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)Platform.getPlayer((ServerWorld)this.getWorld()), (ItemStack)details.getOutput(ic, this.getWorld()), (IInventory)ic);
                    for (int x = 0; x < ic.func_70302_i_(); ++x) {
                        ItemStack output = Platform.getContainerItem(ic.func_70301_a(x));
                        if (output.func_190926_b()) continue;
                        AEItemStack cItem = AEItemStack.fromItemStack(output);
                        this.postChange(cItem, this.machineSrc);
                        this.waitingFor.add(cItem);
                        this.postCraftingStatusChange(cItem);
                    }
                }
                ic = null;
                this.markDirty();
                e.getValue().value--;
                if (e.getValue().value <= 0L || this.remainingOperations != 0) continue;
                return;
            }
            if (ic == null) continue;
            for (int x = 0; x < ic.func_70302_i_(); ++x) {
                ItemStack is = ic.func_70301_a(x);
                if (is.func_190926_b()) continue;
                this.inventory.injectItems(AEItemStack.fromItemStack(is), Actionable.MODULATE, (IActionSource)this.machineSrc);
            }
        }
    }

    private void storeItems() {
        IGrid g = this.getGrid();
        if (g == null) {
            return;
        }
        IStorageGrid sg = (IStorageGrid)g.getCache(IStorageGrid.class);
        IMEMonitor<IAEItemStack> ii = sg.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        for (IAEItemStack is : this.inventory.getItemList()) {
            if ((is = this.inventory.extractItems(is.copy(), Actionable.MODULATE, (IActionSource)this.machineSrc)) != null) {
                this.postChange(is, this.machineSrc);
                is = ii.injectItems(is, Actionable.MODULATE, this.machineSrc);
            }
            if (is == null) continue;
            this.inventory.injectItems(is, Actionable.MODULATE, (IActionSource)this.machineSrc);
        }
        if (this.inventory.getItemList().isEmpty()) {
            this.inventory = new MECraftingInventory();
        }
        this.markDirty();
    }

    public ICraftingLink submitJob(IGrid g, ICraftingJob job, IActionSource src, ICraftingRequester requestingMachine) {
        if (!this.tasks.isEmpty() || !this.waitingFor.isEmpty()) {
            return null;
        }
        if (!(job instanceof CraftingJob)) {
            return null;
        }
        if (this.isBusy() || !this.isActive() || this.availableStorage < job.getByteTotal()) {
            return null;
        }
        IStorageGrid sg = (IStorageGrid)g.getCache(IStorageGrid.class);
        IMEMonitor<IAEItemStack> storage = sg.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        MECraftingInventory ci = new MECraftingInventory(storage, true, false, false);
        try {
            this.waitingFor.resetStatus();
            ((CraftingJob)job).getTree().setJob(ci, this, src);
            if (ci.commit(src)) {
                this.finalOutput = job.getOutput();
                this.waiting = false;
                this.isComplete = false;
                this.markDirty();
                this.updateCPU();
                String craftID = this.generateCraftingID();
                this.myLastLink = new CraftingLink(this.generateLinkData(craftID, requestingMachine == null, false), this);
                this.prepareElapsedTime();
                if (requestingMachine == null) {
                    return this.myLastLink;
                }
                CraftingLink whatLink = new CraftingLink(this.generateLinkData(craftID, false, true), requestingMachine);
                this.submitLink(this.myLastLink);
                this.submitLink(whatLink);
                IItemList<IAEItemStack> list = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
                this.getListOfItem(list, CraftingItemList.ALL);
                for (IAEItemStack ge : list) {
                    this.postChange(ge, this.machineSrc);
                }
                return whatLink;
            }
            this.tasks.clear();
            this.inventory.getItemList().resetStatus();
        }
        catch (CraftBranchFailure e) {
            this.tasks.clear();
            this.inventory.getItemList().resetStatus();
        }
        return null;
    }

    @Override
    public boolean isBusy() {
        Iterator<Map.Entry<ICraftingPatternDetails, TaskProgress>> i = this.tasks.entrySet().iterator();
        while (i.hasNext()) {
            if (i.next().getValue().value > 0L) continue;
            i.remove();
        }
        return !this.tasks.isEmpty() || !this.waitingFor.isEmpty();
    }

    @Override
    public IActionSource getActionSource() {
        return this.machineSrc;
    }

    @Override
    public long getAvailableStorage() {
        return this.availableStorage;
    }

    @Override
    public int getCoProcessors() {
        return this.accelerator;
    }

    @Override
    public ITextComponent getName() {
        return this.myName;
    }

    public boolean isActive() {
        CraftingTileEntity core = this.getCore();
        if (core == null) {
            return false;
        }
        IGridNode node = core.getActionableNode();
        if (node == null) {
            return false;
        }
        return node.isActive();
    }

    private String generateCraftingID() {
        long now = System.currentTimeMillis();
        int hash = System.identityHashCode(this);
        int hmm = this.finalOutput == null ? 0 : this.finalOutput.hashCode();
        return Long.toString(now, 36) + '-' + Integer.toString(hash, 36) + '-' + Integer.toString(hmm, 36);
    }

    private CompoundNBT generateLinkData(String craftingID, boolean standalone, boolean req) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("CraftID", craftingID);
        tag.func_74757_a("canceled", false);
        tag.func_74757_a("done", false);
        tag.func_74757_a("standalone", standalone);
        tag.func_74757_a("req", req);
        return tag;
    }

    private void submitLink(ICraftingLink myLastLink2) {
        if (this.getGrid() != null) {
            CraftingGridCache cc = (CraftingGridCache)this.getGrid().getCache(ICraftingGrid.class);
            cc.addLink((CraftingLink)myLastLink2);
        }
    }

    public void getListOfItem(IItemList<IAEItemStack> list, CraftingItemList whichList) {
        switch (whichList) {
            case ACTIVE: {
                for (IAEItemStack iAEItemStack : this.waitingFor) {
                    list.add(iAEItemStack);
                }
                break;
            }
            case PENDING: {
                for (Map.Entry<ICraftingPatternDetails, TaskProgress> entry : this.tasks.entrySet()) {
                    for (IAEItemStack ais : entry.getKey().getCondensedOutputs()) {
                        ais = ais.copy();
                        ais.setStackSize(ais.getStackSize() * entry.getValue().value);
                        list.add(ais);
                    }
                }
                break;
            }
            case STORAGE: {
                this.inventory.getAvailableItems(list);
                break;
            }
            default: {
                this.inventory.getAvailableItems(list);
                for (IAEItemStack iAEItemStack : this.waitingFor) {
                    list.add(iAEItemStack);
                }
                for (Map.Entry entry : this.tasks.entrySet()) {
                    for (IAEItemStack ais : ((ICraftingPatternDetails)entry.getKey()).getCondensedOutputs()) {
                        ais = ais.copy();
                        ais.setStackSize(ais.getStackSize() * ((TaskProgress)entry.getValue()).value);
                        list.add(ais);
                    }
                }
            }
        }
    }

    public void addStorage(IAEItemStack extractItems) {
        this.inventory.injectItems(extractItems, Actionable.MODULATE, (IActionSource)null);
    }

    public void addEmitable(IAEItemStack i) {
        this.waitingFor.add(i);
        this.postCraftingStatusChange(i);
    }

    public void addCrafting(ICraftingPatternDetails details, long crafts) {
        TaskProgress i = this.tasks.get(details);
        if (i == null) {
            i = new TaskProgress();
            this.tasks.put(details, i);
        }
        TaskProgress taskProgress = i;
        taskProgress.value = taskProgress.value + crafts;
    }

    public IAEItemStack getItemStack(IAEItemStack what, CraftingItemList storage2) {
        IAEItemStack is;
        switch (storage2) {
            case STORAGE: {
                is = this.inventory.getItemList().findPrecise(what);
                break;
            }
            case ACTIVE: {
                is = this.waitingFor.findPrecise(what);
                break;
            }
            case PENDING: {
                is = what.copy();
                is.setStackSize(0L);
                for (Map.Entry<ICraftingPatternDetails, TaskProgress> t : this.tasks.entrySet()) {
                    for (IAEItemStack ais : t.getKey().getCondensedOutputs()) {
                        if (!ais.equals(is)) continue;
                        is.setStackSize(is.getStackSize() + ais.getStackSize() * t.getValue().value);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Invalid Operation");
            }
        }
        if (is != null) {
            return is.copy();
        }
        is = what.copy();
        is.setStackSize(0L);
        return is;
    }

    public void writeToNBT(CompoundNBT data) {
        data.func_218657_a("finalOutput", (INBT)this.writeItem(this.finalOutput));
        data.func_218657_a("inventory", (INBT)this.writeList(this.inventory.getItemList()));
        data.func_74757_a("waiting", this.waiting);
        data.func_74757_a("isComplete", this.isComplete);
        if (this.myLastLink != null) {
            CompoundNBT link = new CompoundNBT();
            this.myLastLink.writeToNBT(link);
            data.func_218657_a("link", (INBT)link);
        }
        ListNBT list = new ListNBT();
        for (Map.Entry<ICraftingPatternDetails, TaskProgress> e : this.tasks.entrySet()) {
            CompoundNBT item = this.writeItem(AEItemStack.fromItemStack(e.getKey().getPattern()));
            item.func_74772_a("craftingProgress", e.getValue().value);
            list.add((Object)item);
        }
        data.func_218657_a("tasks", (INBT)list);
        data.func_218657_a("waitingFor", (INBT)this.writeList(this.waitingFor));
        data.func_74772_a("elapsedTime", this.getElapsedTime());
        data.func_74772_a("startItemCount", this.getStartItemCount());
        data.func_74772_a("remainingItemCount", this.getRemainingItemCount());
    }

    private CompoundNBT writeItem(IAEItemStack finalOutput2) {
        CompoundNBT out = new CompoundNBT();
        if (finalOutput2 != null) {
            finalOutput2.writeToNBT(out);
        }
        return out;
    }

    private ListNBT writeList(IItemList<IAEItemStack> myList) {
        ListNBT out = new ListNBT();
        for (IAEItemStack ais : myList) {
            out.add((Object)this.writeItem(ais));
        }
        return out;
    }

    void done() {
        CraftingTileEntity core = this.getCore();
        core.setCoreBlock(true);
        if (core.getPreviousState() != null) {
            this.readFromNBT(core.getPreviousState());
            core.setPreviousState(null);
        }
        this.updateCPU();
        this.updateName();
    }

    public void readFromNBT(CompoundNBT data) {
        this.finalOutput = AEItemStack.fromNBT(data.func_74775_l("finalOutput"));
        for (IAEItemStack ais : this.readList(data.func_150295_c("inventory", 10))) {
            this.inventory.injectItems(ais, Actionable.MODULATE, (IActionSource)this.machineSrc);
        }
        this.waiting = data.func_74767_n("waiting");
        this.isComplete = data.func_74767_n("isComplete");
        if (data.func_74764_b("link")) {
            CompoundNBT link = data.func_74775_l("link");
            this.myLastLink = new CraftingLink(link, this);
            this.submitLink(this.myLastLink);
        }
        ListNBT list = data.func_150295_c("tasks", 10);
        for (int x = 0; x < list.size(); ++x) {
            ICraftingPatternDetails details;
            CompoundNBT item = list.func_150305_b(x);
            IAEItemStack pattern = AEItemStack.fromNBT(item);
            ICraftingHelper craftingHelper = Api.instance().crafting();
            if (!craftingHelper.isEncodedPattern(pattern) || (details = craftingHelper.decodePattern(pattern.createItemStack(), this.getWorld())) == null) continue;
            TaskProgress tp = new TaskProgress();
            tp.value = item.func_74763_f("craftingProgress");
            this.tasks.put(details, tp);
        }
        this.waitingFor = this.readList(data.func_150295_c("waitingFor", 10));
        for (IAEItemStack is : this.waitingFor) {
            this.postCraftingStatusChange(is.copy());
        }
        this.lastTime = System.nanoTime();
        this.elapsedTime = data.func_74763_f("elapsedTime");
        this.startItemCount = data.func_74763_f("startItemCount");
        this.remainingItemCount = data.func_74763_f("remainingItemCount");
    }

    public void updateName() {
        this.myName = null;
        for (CraftingTileEntity te : this.tiles) {
            if (!te.hasCustomInventoryName()) continue;
            if (this.myName != null) {
                this.myName.func_150258_a(" ").func_150257_a(te.getCustomInventoryName());
                continue;
            }
            this.myName = te.getCustomInventoryName().func_212638_h();
        }
    }

    private IItemList<IAEItemStack> readList(ListNBT tag) {
        IItemList<IAEItemStack> out = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        if (tag == null) {
            return out;
        }
        for (int x = 0; x < tag.size(); ++x) {
            IAEItemStack ais = AEItemStack.fromNBT(tag.func_150305_b(x));
            if (ais == null) continue;
            out.add(ais);
        }
        return out;
    }

    private World getWorld() {
        return this.getCore().func_145831_w();
    }

    public IAEItemStack making(IAEItemStack what) {
        return this.waitingFor.findPrecise(what);
    }

    public void breakCluster() {
        CraftingTileEntity t = this.getCore();
        if (t != null) {
            t.breakCluster();
        }
    }

    private void prepareElapsedTime() {
        this.lastTime = System.nanoTime();
        this.elapsedTime = 0L;
        IItemList<IAEItemStack> list = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        this.getListOfItem(list, CraftingItemList.ACTIVE);
        this.getListOfItem(list, CraftingItemList.PENDING);
        int itemCount = 0;
        for (IAEItemStack ge : list) {
            itemCount = (int)((long)itemCount + ge.getStackSize());
        }
        this.startItemCount = itemCount;
        this.remainingItemCount = itemCount;
    }

    private void updateElapsedTime(IAEItemStack is) {
        long nextStartTime = System.nanoTime();
        this.elapsedTime = this.getElapsedTime() + nextStartTime - this.lastTime;
        this.lastTime = nextStartTime;
        this.remainingItemCount = this.getRemainingItemCount() - is.getStackSize();
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public long getRemainingItemCount() {
        return this.remainingItemCount;
    }

    public long getStartItemCount() {
        return this.startItemCount;
    }

    private static class TaskProgress {
        private long value;

        private TaskProgress() {
        }
    }
}

