/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.IBlocks;
import appeng.api.util.WorldCoord;
import appeng.core.Api;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.MBCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.tile.qnb.QuantumBridgeTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class QuantumCalculator
extends MBCalculator {
    private final QuantumBridgeTileEntity tqb;

    public QuantumCalculator(IAEMultiBlock t) {
        super(t);
        this.tqb = (QuantumBridgeTileEntity)t;
    }

    @Override
    public boolean checkMultiblockScale(WorldCoord min, WorldCoord max) {
        if ((max.x - min.x + 1) * (max.y - min.y + 1) * (max.z - min.z + 1) == 9) {
            int ones = (max.x - min.x == 0 ? 1 : 0) + (max.y - min.y == 0 ? 1 : 0) + (max.z - min.z == 0 ? 1 : 0);
            int threes = (max.x - min.x == 2 ? 1 : 0) + (max.y - min.y == 2 ? 1 : 0) + (max.z - min.z == 2 ? 1 : 0);
            return ones == 1 && threes == 2;
        }
        return false;
    }

    @Override
    public IAECluster createCluster(World w, WorldCoord min, WorldCoord max) {
        return new QuantumCluster(min, max);
    }

    @Override
    public boolean verifyInternalStructure(World w, WorldCoord min, WorldCoord max) {
        int num = 0;
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    BlockPos p = new BlockPos(x, y, z);
                    IAEMultiBlock te = (IAEMultiBlock)w.func_175625_s(p);
                    if (!te.isValid()) {
                        return false;
                    }
                    num = (byte)(num + 1);
                    IBlocks blocks = Api.instance().definitions().blocks();
                    if (!(num == 5 ? !this.isBlockAtLocation((IBlockReader)w, p, blocks.quantumLink()) : !this.isBlockAtLocation((IBlockReader)w, p, blocks.quantumRing()))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void disconnect() {
        this.tqb.disconnect(true);
    }

    @Override
    public void updateTiles(IAECluster cl, World w, WorldCoord min, WorldCoord max) {
        byte num = 0;
        int ringNum = 0;
        QuantumCluster c = (QuantumCluster)cl;
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    byte flags;
                    QuantumBridgeTileEntity te = (QuantumBridgeTileEntity)w.func_175625_s(new BlockPos(x, y, z));
                    if ((num = (byte)((byte)(num + 1))) == 5) {
                        flags = num;
                        c.setCenter(te);
                    } else {
                        flags = num == 1 || num == 3 || num == 7 || num == 9 ? (byte)((byte)(this.tqb.getCorner() | num)) : num;
                        c.getRing()[ringNum] = te;
                        ringNum = (byte)(ringNum + 1);
                    }
                    te.updateStatus(c, flags, true);
                }
            }
        }
    }

    @Override
    public boolean isValidTile(TileEntity te) {
        return te instanceof QuantumBridgeTileEntity;
    }

    private boolean isBlockAtLocation(IBlockReader w, BlockPos pos, IBlockDefinition def) {
        return def.maybeBlock().map(block -> block == w.func_180495_p(pos).func_177230_c()).orElse(false);
    }
}

