/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.events.LocatableEventAnnounce;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.features.ILocatable;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.AEPartLocation;
import appeng.api.util.WorldCoord;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.me.cache.helpers.ConnectionWrapper;
import appeng.me.cluster.IAECluster;
import appeng.tile.qnb.QuantumBridgeTileEntity;
import appeng.util.iterators.ChainedIterator;
import java.util.Iterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class QuantumCluster
implements ILocatable,
IAECluster {
    private final WorldCoord min;
    private final WorldCoord max;
    private boolean isDestroyed = false;
    private boolean updateStatus = true;
    private QuantumBridgeTileEntity[] Ring;
    private boolean registered = false;
    private ConnectionWrapper connection;
    private long thisSide;
    private long otherSide;
    private QuantumBridgeTileEntity center;

    public QuantumCluster(WorldCoord min, WorldCoord max) {
        this.min = min;
        this.max = max;
        this.setRing(new QuantumBridgeTileEntity[8]);
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload e) {
        if (this.center.func_145831_w() == e.getWorld()) {
            this.setUpdateStatus(false);
            this.destroy();
        }
    }

    @Override
    public void updateStatus(boolean updateGrid) {
        long qe = this.center.getQEFrequency();
        if (this.thisSide != qe && this.thisSide != -qe) {
            if (qe != 0L) {
                if (this.thisSide != 0L) {
                    MinecraftForge.EVENT_BUS.post((Event)new LocatableEventAnnounce(this, LocatableEventAnnounce.LocatableEvent.UNREGISTER));
                }
                if (this.canUseNode(-qe)) {
                    this.otherSide = qe;
                    this.thisSide = -qe;
                } else if (this.canUseNode(qe)) {
                    this.thisSide = qe;
                    this.otherSide = -qe;
                }
                MinecraftForge.EVENT_BUS.post((Event)new LocatableEventAnnounce(this, LocatableEventAnnounce.LocatableEvent.REGISTER));
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new LocatableEventAnnounce(this, LocatableEventAnnounce.LocatableEvent.UNREGISTER));
                this.otherSide = 0L;
                this.thisSide = 0L;
            }
        }
        ILocatable myOtherSide = this.otherSide == 0L ? null : Api.instance().registries().locatable().getLocatableBy(this.otherSide);
        boolean shutdown = false;
        if (myOtherSide instanceof QuantumCluster) {
            QuantumCluster sideA = this;
            QuantumCluster sideB = (QuantumCluster)myOtherSide;
            if (sideA.isActive() && sideB.isActive()) {
                if (this.connection != null && this.connection.getConnection() != null) {
                    IGridNode a = this.connection.getConnection().a();
                    IGridNode b = this.connection.getConnection().b();
                    IGridNode sa = sideA.getNode();
                    IGridNode sb = sideB.getNode();
                    if (!(a != sa && b != sa || a != sb && b != sb)) {
                        return;
                    }
                }
                try {
                    if (sideA.connection != null && sideA.connection.getConnection() != null) {
                        sideA.connection.getConnection().destroy();
                        sideA.connection = new ConnectionWrapper(null);
                    }
                    if (sideB.connection != null && sideB.connection.getConnection() != null) {
                        sideB.connection.getConnection().destroy();
                        sideB.connection = new ConnectionWrapper(null);
                    }
                    sideA.connection = sideB.connection = new ConnectionWrapper(Api.instance().grid().createGridConnection(sideA.getNode(), sideB.getNode()));
                }
                catch (FailedConnectionException e) {
                    AELog.debug(e);
                }
            } else {
                shutdown = true;
            }
        } else {
            shutdown = true;
        }
        if (shutdown && this.connection != null && this.connection.getConnection() != null) {
            this.connection.getConnection().destroy();
            this.connection.setConnection(null);
            this.connection = new ConnectionWrapper(null);
        }
    }

    private boolean canUseNode(long qe) {
        QuantumCluster qc = (QuantumCluster)Api.instance().registries().locatable().getLocatableBy(qe);
        if (qc != null) {
            World theWorld = qc.center.func_145831_w();
            if (!qc.isDestroyed) {
                ChunkPos cPos = new ChunkPos(qc.center.func_174877_v());
                if (theWorld.func_72863_F().func_222865_a(cPos)) {
                    DimensionType id = theWorld.field_73011_w.func_186058_p();
                    ServerWorld cur = theWorld.func_73046_m().func_71218_a(id);
                    TileEntity te = theWorld.func_175625_s(qc.center.func_174877_v());
                    return te != qc.center || theWorld != cur;
                }
            }
        }
        return true;
    }

    private boolean isActive() {
        if (this.isDestroyed || !this.registered) {
            return false;
        }
        return this.center.isPowered() && this.hasQES();
    }

    private IGridNode getNode() {
        return this.center.getGridNode(AEPartLocation.INTERNAL);
    }

    private boolean hasQES() {
        return this.thisSide != 0L;
    }

    @Override
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        if (this.registered) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.registered = false;
        }
        if (this.thisSide != 0L) {
            this.updateStatus(true);
            MinecraftForge.EVENT_BUS.post((Event)new LocatableEventAnnounce(this, LocatableEventAnnounce.LocatableEvent.UNREGISTER));
        }
        this.center.updateStatus(null, (byte)-1, this.isUpdateStatus());
        for (QuantumBridgeTileEntity r : this.getRing()) {
            r.updateStatus(null, (byte)-1, this.isUpdateStatus());
        }
        this.center = null;
        this.setRing(new QuantumBridgeTileEntity[8]);
    }

    @Override
    public Iterator<IGridHost> getTiles() {
        return new ChainedIterator<IGridHost>(this.getRing()[0], this.getRing()[1], this.getRing()[2], this.getRing()[3], this.getRing()[4], this.getRing()[5], this.getRing()[6], this.getRing()[7], this.center);
    }

    public boolean isCorner(QuantumBridgeTileEntity tileQuantumBridge) {
        return this.getRing()[0] == tileQuantumBridge || this.getRing()[2] == tileQuantumBridge || this.getRing()[4] == tileQuantumBridge || this.getRing()[6] == tileQuantumBridge;
    }

    @Override
    public long getLocatableSerial() {
        return this.thisSide;
    }

    public QuantumBridgeTileEntity getCenter() {
        return this.center;
    }

    void setCenter(QuantumBridgeTileEntity c) {
        this.registered = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.center = c;
    }

    private boolean isUpdateStatus() {
        return this.updateStatus;
    }

    public void setUpdateStatus(boolean updateStatus) {
        this.updateStatus = updateStatus;
    }

    QuantumBridgeTileEntity[] getRing() {
        return this.Ring;
    }

    private void setRing(QuantumBridgeTileEntity[] ring) {
        this.Ring = ring;
    }
}

