/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.networking.IGridHost;
import appeng.api.util.DimensionalCoord;
import appeng.me.cluster.IAECluster;
import appeng.tile.spatial.SpatialPylonTileEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpatialPylonCluster
implements IAECluster {
    private final DimensionalCoord min;
    private final DimensionalCoord max;
    private final List<SpatialPylonTileEntity> line = new ArrayList<SpatialPylonTileEntity>();
    private boolean isDestroyed = false;
    private Axis currentAxis = Axis.UNFORMED;
    private boolean isValid;

    public SpatialPylonCluster(DimensionalCoord min, DimensionalCoord max) {
        this.min = min.copy();
        this.max = max.copy();
        if (this.getMin().x != this.getMax().x) {
            this.setCurrentAxis(Axis.X);
        } else if (this.getMin().y != this.getMax().y) {
            this.setCurrentAxis(Axis.Y);
        } else if (this.getMin().z != this.getMax().z) {
            this.setCurrentAxis(Axis.Z);
        } else {
            this.setCurrentAxis(Axis.UNFORMED);
        }
    }

    @Override
    public void updateStatus(boolean updateGrid) {
        for (SpatialPylonTileEntity r : this.getLine()) {
            r.recalculateDisplay();
        }
    }

    @Override
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        for (SpatialPylonTileEntity r : this.getLine()) {
            r.updateStatus(null);
        }
    }

    @Override
    public Iterator<IGridHost> getTiles() {
        return this.getLine().iterator();
    }

    public int tileCount() {
        return this.getLine().size();
    }

    public Axis getCurrentAxis() {
        return this.currentAxis;
    }

    private void setCurrentAxis(Axis currentAxis) {
        this.currentAxis = currentAxis;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public DimensionalCoord getMax() {
        return this.max;
    }

    public DimensionalCoord getMin() {
        return this.min;
    }

    List<SpatialPylonTileEntity> getLine() {
        return this.line;
    }

    public static enum Axis {
        X,
        Y,
        Z,
        UNFORMED;

    }
}

