/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.FormationPlaneContainer;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.automation.AbstractFormationPlanePart;
import appeng.parts.automation.PlaneModelData;
import appeng.parts.automation.PlaneModels;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.PrecisePriorityList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.FireworkStarItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.IItemHandler;

public class FormationPlanePart
extends AbstractFormationPlanePart<IAEItemStack> {
    private static final PlaneModels MODELS = new PlaneModels("part/formation_plane", "part/formation_plane_on");
    private final MEInventoryHandler<IAEItemStack> myHandler = new MEInventoryHandler<IAEItemStack>(this, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
    private final AppEngInternalAEInventory Config = new AppEngInternalAEInventory(this, 63);

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public FormationPlanePart(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.PLACE_BLOCK, YesNo.YES);
        this.updateHandler();
    }

    @Override
    protected void updateHandler() {
        this.myHandler.setBaseAccess(AccessRestriction.WRITE);
        this.myHandler.setWhitelist(this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
        this.myHandler.setPriority(this.getPriority());
        IItemList<IAEItemStack> priorityList = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
        for (int x = 0; x < this.Config.getSlots() && x < slotsToUse; ++x) {
            IAEItemStack is = this.Config.getAEStackInSlot(x);
            if (is == null) continue;
            priorityList.add(is);
        }
        if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            this.myHandler.setPartitionList(new FuzzyPriorityList(priorityList, (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE)));
        } else {
            this.myHandler.setPartitionList(new PrecisePriorityList(priorityList));
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
        if (inv == this.Config) {
            this.updateHandler();
        }
    }

    @Override
    public void readFromNBT(CompoundNBT data) {
        super.readFromNBT(data);
        this.Config.readFromNBT(data, "config");
        this.updateHandler();
    }

    @Override
    public void writeToNBT(CompoundNBT data) {
        super.writeToNBT(data);
        this.Config.writeToNBT(data, "config");
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.Config;
        }
        return super.getInventoryByName(name);
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.stateChanged();
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged changedChannels) {
        this.stateChanged();
    }

    @Override
    public boolean onPartActivate(PlayerEntity player, Hand hand, Vec3d pos) {
        if (Platform.isServer()) {
            ContainerOpener.openContainer(FormationPlaneContainer.TYPE, player, ContainerLocator.forPart(this));
        }
        return true;
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (this.getProxy().isActive() && channel == Api.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            ArrayList<IMEInventoryHandler> handler = new ArrayList<IMEInventoryHandler>(1);
            handler.add(this.myHandler);
            return handler;
        }
        return Collections.emptyList();
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
        if (this.blocked || input == null || input.getStackSize() <= 0L) {
            return input;
        }
        YesNo placeBlock = (YesNo)this.getConfigManager().getSetting(Settings.PLACE_BLOCK);
        ItemStack is = input.createItemStack();
        Item i = is.func_77973_b();
        long maxStorage = Math.min(input.getStackSize(), (long)is.func_77976_d());
        boolean worked = false;
        TileEntity te = this.getHost().getTile();
        World w = te.func_145831_w();
        AEPartLocation side = this.getSide();
        BlockPos placePos = te.func_174877_v().func_177972_a(side.getFacing());
        if (w.func_180495_p(placePos).func_185904_a().func_76222_j()) {
            if (placeBlock == YesNo.YES && (i instanceof BlockItem || i instanceof IPlantable || i instanceof FireworkStarItem || i instanceof FireworkRocketItem || i instanceof IPartItem)) {
                PlayerEntity player = Platform.getPlayer((ServerWorld)w);
                Platform.configurePlayer(player, side, this.getTile());
                Hand hand = player.func_184600_cs();
                player.func_184611_a(hand, is);
                maxStorage = is.func_190916_E();
                worked = true;
                if (type == Actionable.MODULATE) {
                    Direction lookDirection = side.getFacing();
                    if (i instanceof IPlantable || i instanceof WallOrFloorItem) {
                        boolean Worked = false;
                        if (side.xOffset == 0 && side.zOffset == 0) {
                            boolean bl = Worked = i.func_195939_a((ItemUseContext)new DirectionalPlaceContext(w, placePos.func_177972_a(side.getFacing()), lookDirection, is, side.getFacing())) == ActionResultType.SUCCESS;
                        }
                        if (!Worked && side.xOffset == 0 && side.zOffset == 0) {
                            boolean bl = Worked = i.func_195939_a((ItemUseContext)new DirectionalPlaceContext(w, placePos.func_177972_a(side.getFacing().func_176734_d()), lookDirection, is, side.getFacing().func_176734_d())) == ActionResultType.SUCCESS;
                        }
                        if (!Worked && side.yOffset == 0) {
                            boolean bl = Worked = i.func_195939_a((ItemUseContext)new DirectionalPlaceContext(w, placePos.func_177972_a(Direction.DOWN), lookDirection, is, Direction.DOWN)) == ActionResultType.SUCCESS;
                        }
                        if (!Worked) {
                            i.func_195939_a((ItemUseContext)new DirectionalPlaceContext(w, placePos, lookDirection, is, lookDirection.func_176734_d()));
                        }
                        maxStorage -= (long)is.func_190916_E();
                    } else {
                        i.func_195939_a((ItemUseContext)new DirectionalPlaceContext(w, placePos, lookDirection, is, lookDirection.func_176734_d()));
                        maxStorage -= (long)is.func_190916_E();
                    }
                } else {
                    maxStorage = 1L;
                }
                player.func_184611_a(hand, ItemStack.field_190927_a);
            } else {
                worked = true;
                int sum = this.countEntitesAround(w, placePos);
                if (sum < AEConfig.instance().getFormationPlaneEntityLimit()) {
                    if (type == Actionable.MODULATE) {
                        ItemEntity ei;
                        is.func_190920_e((int)maxStorage);
                        double x = (side.xOffset != 0 ? 0.0 : 0.7 * ((double)Platform.getRandomFloat() - 0.5)) + (double)side.xOffset + 0.5 + (double)te.func_174877_v().func_177958_n();
                        double y = (side.yOffset != 0 ? 0.0 : 0.7 * ((double)Platform.getRandomFloat() - 0.5)) + (double)side.yOffset + 0.5 + (double)te.func_174877_v().func_177956_o();
                        double z = (side.zOffset != 0 ? 0.0 : 0.7 * ((double)Platform.getRandomFloat() - 0.5)) + (double)side.zOffset + 0.5 + (double)te.func_174877_v().func_177952_p();
                        ItemEntity result = ei = new ItemEntity(w, x, y, z, is.func_77946_l());
                        ei.func_213293_j((double)side.xOffset * 0.2, (double)side.yOffset * 0.2, (double)side.zOffset * 0.2);
                        if (is.func_77973_b().hasCustomEntity(is)) {
                            result = is.func_77973_b().createEntity(w, (Entity)ei, is);
                            if (result != null) {
                                ei.func_70106_y();
                            } else {
                                result = ei;
                            }
                        }
                        if (!w.func_217376_c((Entity)result)) {
                            result.func_70106_y();
                            worked = false;
                        }
                    }
                } else {
                    worked = false;
                }
            }
        }
        boolean bl = this.blocked = !w.func_180495_p(placePos).func_185904_a().func_76222_j();
        if (worked) {
            IAEItemStack out = input.copy();
            out.decStackSize(maxStorage);
            if (out.getStackSize() == 0L) {
                return null;
            }
            return out;
        }
        return input;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new PlaneModelData(this.getConnections());
    }

    @Override
    public ItemStack getItemStackRepresentation() {
        return Api.instance().definitions().parts().formationPlane().maybeStack(1).orElse(ItemStack.field_190927_a);
    }

    @Override
    public ContainerType<?> getContainerType() {
        return FormationPlaneContainer.TYPE;
    }

    private int countEntitesAround(World world, BlockPos pos) {
        AxisAlignedBB t = new AxisAlignedBB(pos).func_186662_g(8.0);
        List list = world.func_217357_a(Entity.class, t);
        return list.size();
    }

    private class ForcedItemUseContext
    extends ItemUseContext {
        protected ForcedItemUseContext(@Nullable World worldIn, PlayerEntity player, Hand handIn, ItemStack heldItem, BlockRayTraceResult rayTraceResultIn) {
            super(worldIn, player, handIn, heldItem, rayTraceResultIn);
        }
    }
}

