/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.util.AEPartLocation;
import appeng.items.parts.PartModels;
import appeng.parts.automation.AnnihilationPlanePart;
import appeng.parts.automation.PlaneModelData;
import appeng.parts.automation.PlaneModels;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.model.data.IModelData;

public class IdentityAnnihilationPlanePart
extends AnnihilationPlanePart {
    private static final PlaneModels MODELS = new PlaneModels("part/identity_annihilation_plane", "part/identity_annihilation_plane_on");
    private static final float SILK_TOUCH_FACTOR = 16.0f;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IdentityAnnihilationPlanePart(ItemStack is) {
        super(is);
    }

    @Override
    protected boolean isAnnihilationPlane(TileEntity blockTileEntity, AEPartLocation side) {
        if (blockTileEntity instanceof IPartHost) {
            IPart p = ((IPartHost)blockTileEntity).getPart(side);
            return p != null && p.getClass() == this.getClass();
        }
        return false;
    }

    @Override
    protected float calculateEnergyUsage(ServerWorld w, BlockPos pos, List<ItemStack> items) {
        float requiredEnergy = super.calculateEnergyUsage(w, pos, items);
        return requiredEnergy * 16.0f;
    }

    @Override
    protected ItemStack createHarvestTool(BlockState state) {
        ItemStack harvestTool = super.createHarvestTool(state);
        if (harvestTool != null) {
            EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)Enchantments.field_185306_r, (Object)1), (ItemStack)harvestTool);
        }
        return harvestTool;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new PlaneModelData(this.getConnections());
    }
}

