/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.items.IItemHandler;

public abstract class UpgradeInventory
extends AppEngInternalInventory
implements IAEAppEngInventory {
    private final IAEAppEngInventory parent;
    private boolean cached = false;
    private int fuzzyUpgrades = 0;
    private int speedUpgrades = 0;
    private int redstoneUpgrades = 0;
    private int capacityUpgrades = 0;
    private int inverterUpgrades = 0;
    private int craftingUpgrades = 0;

    public UpgradeInventory(IAEAppEngInventory parent, int s) {
        super(null, s, 1);
        this.setTileEntity(this);
        this.parent = parent;
        this.setFilter(new UpgradeInvFilter());
    }

    @Override
    protected boolean eventsEnabled() {
        return true;
    }

    public int getInstalledUpgrades(Upgrades u) {
        if (!this.cached) {
            this.updateUpgradeInfo();
        }
        switch (u) {
            case CAPACITY: {
                return this.capacityUpgrades;
            }
            case FUZZY: {
                return this.fuzzyUpgrades;
            }
            case REDSTONE: {
                return this.redstoneUpgrades;
            }
            case SPEED: {
                return this.speedUpgrades;
            }
            case INVERTER: {
                return this.inverterUpgrades;
            }
            case CRAFTING: {
                return this.craftingUpgrades;
            }
        }
        return 0;
    }

    public abstract int getMaxInstalled(Upgrades var1);

    private void updateUpgradeInfo() {
        this.cached = true;
        this.craftingUpgrades = 0;
        this.fuzzyUpgrades = 0;
        this.speedUpgrades = 0;
        this.redstoneUpgrades = 0;
        this.capacityUpgrades = 0;
        this.inverterUpgrades = 0;
        for (ItemStack is : this) {
            if (is == null || is.func_77973_b() == Items.field_190931_a || !(is.func_77973_b() instanceof IUpgradeModule)) continue;
            Upgrades myUpgrade = ((IUpgradeModule)is.func_77973_b()).getType(is);
            switch (myUpgrade) {
                case CAPACITY: {
                    ++this.capacityUpgrades;
                    break;
                }
                case FUZZY: {
                    ++this.fuzzyUpgrades;
                    break;
                }
                case REDSTONE: {
                    ++this.redstoneUpgrades;
                    break;
                }
                case SPEED: {
                    ++this.speedUpgrades;
                    break;
                }
                case INVERTER: {
                    ++this.inverterUpgrades;
                    break;
                }
                case CRAFTING: {
                    ++this.craftingUpgrades;
                    break;
                }
            }
        }
        this.capacityUpgrades = Math.min(this.capacityUpgrades, this.getMaxInstalled(Upgrades.CAPACITY));
        this.fuzzyUpgrades = Math.min(this.fuzzyUpgrades, this.getMaxInstalled(Upgrades.FUZZY));
        this.redstoneUpgrades = Math.min(this.redstoneUpgrades, this.getMaxInstalled(Upgrades.REDSTONE));
        this.speedUpgrades = Math.min(this.speedUpgrades, this.getMaxInstalled(Upgrades.SPEED));
        this.inverterUpgrades = Math.min(this.inverterUpgrades, this.getMaxInstalled(Upgrades.INVERTER));
        this.craftingUpgrades = Math.min(this.craftingUpgrades, this.getMaxInstalled(Upgrades.CRAFTING));
    }

    @Override
    public void readFromNBT(CompoundNBT target) {
        super.readFromNBT(target);
        this.updateUpgradeInfo();
    }

    @Override
    public void saveChanges() {
        if (this.parent != null) {
            this.parent.saveChanges();
        }
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.cached = false;
        if (this.parent != null && Platform.isServer()) {
            this.parent.onChangeInventory(inv, slot, mc, removedStack, newStack);
        }
    }

    private class UpgradeInvFilter
    implements IAEItemFilter {
        private UpgradeInvFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack itemstack) {
            Upgrades u;
            if (itemstack.func_190926_b()) {
                return false;
            }
            Item it = itemstack.func_77973_b();
            if (it instanceof IUpgradeModule && (u = ((IUpgradeModule)it).getType(itemstack)) != null) {
                return UpgradeInventory.this.getInstalledUpgrades(u) < UpgradeInventory.this.getMaxInstalled(u);
            }
            return false;
        }
    }
}

