/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.misc;

import appeng.api.networking.IGridNode;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CableAnchorPart
implements IPart {
    @PartModels
    public static final PartModel DEFAULT_MODELS = new PartModel(false, new ResourceLocation("appliedenergistics2", "part/cable_anchor"));
    @PartModels
    public static final PartModel FACADE_MODELS = new PartModel(false, new ResourceLocation("appliedenergistics2", "part/cable_anchor_short"));
    private ItemStack is = ItemStack.field_190927_a;
    private IPartHost host = null;
    private AEPartLocation mySide = AEPartLocation.UP;

    public CableAnchorPart(ItemStack is) {
        this.is = is;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        if (this.host != null && this.host.getFacadeContainer().getFacade(this.mySide) != null) {
            bch.addBox(7.0, 7.0, 10.0, 9.0, 9.0, 14.0);
        } else {
            bch.addBox(7.0, 7.0, 10.0, 9.0, 9.0, 16.0);
        }
    }

    @Override
    public ItemStack getItemStack(PartItemStack wrenched) {
        return this.is;
    }

    @Override
    public boolean requireDynamicRender() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean canConnectRedstone() {
        return false;
    }

    @Override
    public void writeToNBT(CompoundNBT data) {
    }

    @Override
    public void readFromNBT(CompoundNBT data) {
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public boolean isLadder(LivingEntity entity) {
        return this.mySide.yOffset == 0 && (entity.field_70123_F || !entity.field_70122_E);
    }

    @Override
    public void onNeighborChanged(IBlockReader w, BlockPos pos, BlockPos neighbor) {
    }

    @Override
    public int isProvidingStrongPower() {
        return 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return 0;
    }

    @Override
    public void writeToStream(PacketBuffer data) throws IOException {
    }

    @Override
    public boolean readFromStream(PacketBuffer data) throws IOException {
        return false;
    }

    @Override
    public IGridNode getGridNode() {
        return null;
    }

    @Override
    public void onEntityCollision(Entity entity) {
    }

    @Override
    public void removeFromWorld() {
    }

    @Override
    public void addToWorld() {
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return null;
    }

    @Override
    public void setPartHostInfo(AEPartLocation side, IPartHost host, TileEntity tile) {
        this.host = host;
        this.mySide = side;
    }

    @Override
    public boolean onActivate(PlayerEntity player, Hand hand, Vec3d pos) {
        return false;
    }

    @Override
    public boolean onShiftActivate(PlayerEntity player, Hand hand, Vec3d pos) {
        return false;
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 0.0f;
    }

    @Override
    public void animateTick(World world, BlockPos pos, Random r) {
    }

    @Override
    public void onPlacement(PlayerEntity player, Hand hand, ItemStack held, AEPartLocation side) {
    }

    @Override
    public boolean canBePlacedOn(BusSupport what) {
        return what == BusSupport.CABLE || what == BusSupport.DENSE_CABLE;
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.host != null && this.host.getFacadeContainer().getFacade(this.mySide) != null) {
            return FACADE_MODELS;
        }
        return DEFAULT_MODELS;
    }
}

