/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidP2PTunnelPart
extends P2PTunnelPart<FluidP2PTunnelPart>
implements IFluidHandler {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_fluids");
    private static final ThreadLocal<Deque<FluidP2PTunnelPart>> DEPTH = new ThreadLocal();
    private LazyOptional<IFluidHandler> cachedTank;
    private int tmpUsed;

    public FluidP2PTunnelPart(ItemStack is) {
        super(is);
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public void onTunnelNetworkChange() {
        this.cachedTank = null;
    }

    @Override
    public void onNeighborChanged(IBlockReader w, BlockPos pos, BlockPos neighbor) {
        FluidP2PTunnelPart in;
        this.cachedTank = null;
        if (this.isOutput() && (in = (FluidP2PTunnelPart)this.getInput()) != null) {
            in.onTunnelNetworkChange();
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capabilityClass) {
        if (capabilityClass == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this);
        }
        return super.getCapability(capabilityClass);
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    public int getTanks() {
        return 0;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        Deque<FluidP2PTunnelPart> stack = this.getDepth();
        for (FluidP2PTunnelPart t : stack) {
            if (t != this) continue;
            return 0;
        }
        stack.push(this);
        List<FluidP2PTunnelPart> list = this.getOutputs(resource.getFluid());
        int requestTotal = 0;
        Iterator<FluidP2PTunnelPart> i = list.iterator();
        while (i.hasNext()) {
            FluidP2PTunnelPart l = i.next();
            IFluidHandler tank = (IFluidHandler)l.getTarget().orElse(null);
            l.tmpUsed = tank != null ? tank.fill(resource.copy(), IFluidHandler.FluidAction.SIMULATE) : 0;
            if (l.tmpUsed <= 0) {
                i.remove();
                continue;
            }
            requestTotal += l.tmpUsed;
        }
        if (requestTotal <= 0) {
            if (stack.pop() != this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return 0;
        }
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            if (stack.pop() != this) {
                throw new IllegalStateException("Invalid Recursion detected.");
            }
            return Math.min(resource.getAmount(), requestTotal);
        }
        int available = resource.getAmount();
        i = list.iterator();
        int used = 0;
        while (i.hasNext() && available > 0) {
            IFluidHandler tank;
            FluidP2PTunnelPart l = i.next();
            FluidStack insert = resource.copy();
            insert.setAmount((int)Math.ceil((double)insert.getAmount() * ((double)l.tmpUsed / (double)requestTotal)));
            if (insert.getAmount() > available) {
                insert.setAmount(available);
            }
            l.tmpUsed = (tank = (IFluidHandler)l.getTarget().orElse(null)) != null ? tank.fill(insert.copy(), action) : 0;
            available -= insert.getAmount();
            used += l.tmpUsed;
        }
        if (stack.pop() != this) {
            throw new IllegalStateException("Invalid Recursion detected.");
        }
        return used;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    private Deque<FluidP2PTunnelPart> getDepth() {
        Deque<FluidP2PTunnelPart> s = DEPTH.get();
        if (s == null) {
            s = new ArrayDeque<FluidP2PTunnelPart>();
            DEPTH.set(s);
        }
        return s;
    }

    private List<FluidP2PTunnelPart> getOutputs(Fluid input) {
        ArrayList<FluidP2PTunnelPart> outs = new ArrayList<FluidP2PTunnelPart>();
        try {
            for (FluidP2PTunnelPart l : this.getOutputs()) {
                IFluidHandler handler = (IFluidHandler)l.getTarget().orElse(null);
                if (handler == null) continue;
                outs.add(l);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return outs;
    }

    private LazyOptional<IFluidHandler> getTarget() {
        if (!this.getProxy().isActive()) {
            return null;
        }
        if (this.cachedTank != null) {
            return this.cachedTank;
        }
        TileEntity te = this.getTile().func_145831_w().func_175625_s(this.getTile().func_174877_v().func_177972_a(this.getSide().getFacing()));
        if (te != null && te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d()).isPresent()) {
            this.cachedTank = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d());
            return this.cachedTank;
        }
        return null;
    }
}

