/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartModel;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import java.io.IOException;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class LightP2PTunnelPart
extends P2PTunnelPart<LightP2PTunnelPart>
implements IGridTickable {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_light");
    private int lastValue = 0;
    private int opacity = -1;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public LightP2PTunnelPart(ItemStack is) {
        super(is);
    }

    @Override
    public void chanRender(MENetworkChannelsChanged c) {
        this.onTunnelNetworkChange();
        super.chanRender(c);
    }

    @Override
    public void powerRender(MENetworkPowerStatusChange c) {
        this.onTunnelNetworkChange();
        super.powerRender(c);
    }

    @Override
    public void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        data.writeInt(this.isOutput() ? this.lastValue : 0);
        data.writeInt(this.opacity);
    }

    @Override
    public boolean readFromStream(PacketBuffer data) throws IOException {
        super.readFromStream(data);
        int oldValue = this.lastValue;
        int oldOpacity = this.opacity;
        this.lastValue = data.readInt();
        this.opacity = data.readInt();
        this.setOutput(this.lastValue > 0);
        return this.lastValue != oldValue || oldOpacity != this.opacity;
    }

    private boolean doWork() {
        if (this.isOutput()) {
            return false;
        }
        TileEntity te = this.getTile();
        World w = te.func_145831_w();
        int newLevel = w.func_201696_r(te.func_174877_v().func_177972_a(this.getSide().getFacing()));
        if (this.lastValue != newLevel && this.getProxy().isActive()) {
            this.lastValue = newLevel;
            try {
                for (LightP2PTunnelPart out : this.getOutputs()) {
                    out.setLightLevel(this.lastValue);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborChanged(IBlockReader w, BlockPos pos, BlockPos neighbor) {
        if (this.isOutput() && pos.func_177972_a(this.getSide().getFacing()).equals((Object)neighbor)) {
            this.opacity = -1;
            this.getHost().markForUpdate();
        } else {
            this.doWork();
        }
    }

    @Override
    public int getLightLevel() {
        if (this.isOutput() && this.isPowered()) {
            return this.blockLight(this.lastValue);
        }
        return 0;
    }

    private void setLightLevel(int out) {
        this.lastValue = out;
        this.getHost().markForUpdate();
    }

    private int blockLight(int emit) {
        if (this.opacity < 0) {
            TileEntity te = this.getTile();
            this.opacity = 255 - te.func_145831_w().func_201696_r(te.func_174877_v().func_177972_a(this.getSide().getFacing()));
        }
        return (int)((float)emit * ((float)this.opacity / 255.0f));
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.lastValue = tag.func_74762_e("lastValue");
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("lastValue", this.lastValue);
    }

    @Override
    public void onTunnelConfigChange() {
        this.onTunnelNetworkChange();
    }

    @Override
    public void onTunnelNetworkChange() {
        if (this.isOutput()) {
            LightP2PTunnelPart src = (LightP2PTunnelPart)this.getInput();
            if (src != null && src.getProxy().isActive()) {
                this.setLightLevel(src.lastValue);
            } else {
                this.getHost().markForUpdate();
            }
        } else {
            this.doWork();
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.LightTunnel.getMin(), TickRates.LightTunnel.getMax(), false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.doWork() ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    public float getPowerDrainPerTick() {
        return 0.5f;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

