/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.parts.IPartModel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.implementations.PatternTermContainer;
import appeng.core.Api;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractTerminalPart;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;

public class PatternTerminalPart
extends AbstractTerminalPart {
    @PartModels
    public static final ResourceLocation MODEL_OFF = new ResourceLocation("appliedenergistics2", "part/pattern_terminal_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = new ResourceLocation("appliedenergistics2", "part/pattern_terminal_on");
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL);
    private final AppEngInternalInventory crafting = new AppEngInternalInventory(this, 9);
    private final AppEngInternalInventory output = new AppEngInternalInventory(this, 3);
    private final AppEngInternalInventory pattern = new AppEngInternalInventory(this, 2);
    private boolean craftingMode = true;
    private boolean substitute = false;

    public PatternTerminalPart(ItemStack is) {
        super(is);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack is : this.pattern) {
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    @Override
    public void readFromNBT(CompoundNBT data) {
        super.readFromNBT(data);
        this.setCraftingRecipe(data.func_74767_n("craftingMode"));
        this.setSubstitution(data.func_74767_n("substitute"));
        this.pattern.readFromNBT(data, "pattern");
        this.output.readFromNBT(data, "outputList");
        this.crafting.readFromNBT(data, "craftingGrid");
    }

    @Override
    public void writeToNBT(CompoundNBT data) {
        super.writeToNBT(data);
        data.func_74757_a("craftingMode", this.craftingMode);
        data.func_74757_a("substitute", this.substitute);
        this.pattern.writeToNBT(data, "pattern");
        this.output.writeToNBT(data, "outputList");
        this.crafting.writeToNBT(data, "craftingGrid");
    }

    @Override
    public ContainerType<?> getContainerType(PlayerEntity p) {
        if (Platform.checkPermissions(p, this, SecurityPermissions.CRAFT, false)) {
            return PatternTermContainer.TYPE;
        }
        return MEMonitorableContainer.TYPE;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.pattern && slot == 1) {
            ItemStack is = this.pattern.getStackInSlot(1);
            ICraftingPatternDetails details = Api.instance().crafting().decodePattern(is, this.getHost().getTile().func_145831_w());
            if (details != null) {
                IAEItemStack item;
                int x;
                this.setCraftingRecipe(details.isCraftable());
                this.setSubstitution(details.canSubstitute());
                for (x = 0; x < this.crafting.getSlots() && x < details.getInputs().length; ++x) {
                    item = details.getInputs()[x];
                    this.crafting.setStackInSlot(x, item == null ? ItemStack.field_190927_a : item.createItemStack());
                }
                for (x = 0; x < this.output.getSlots() && x < details.getOutputs().length; ++x) {
                    item = details.getOutputs()[x];
                    this.output.setStackInSlot(x, item == null ? ItemStack.field_190927_a : item.createItemStack());
                }
            }
        } else if (inv == this.crafting) {
            this.fixCraftingRecipes();
        }
        this.getHost().markForSave();
    }

    private void fixCraftingRecipes() {
        if (this.craftingMode) {
            for (int x = 0; x < this.crafting.getSlots(); ++x) {
                ItemStack is = this.crafting.getStackInSlot(x);
                if (is.func_190926_b()) continue;
                is.func_190920_e(1);
            }
        }
    }

    public boolean isCraftingRecipe() {
        return this.craftingMode;
    }

    public void setCraftingRecipe(boolean craftingMode) {
        this.craftingMode = craftingMode;
        this.fixCraftingRecipes();
    }

    public boolean isSubstitution() {
        return this.substitute;
    }

    public void setSubstitution(boolean canSubstitute) {
        this.substitute = canSubstitute;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.crafting;
        }
        if (name.equals("output")) {
            return this.output;
        }
        if (name.equals("pattern")) {
            return this.pattern;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }
}

