/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.api.features.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class InscriberRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<InscriberRecipe> {
    public static final InscriberRecipeSerializer INSTANCE = new InscriberRecipeSerializer();

    private InscriberRecipeSerializer() {
    }

    private static InscriberProcessType getMode(JsonObject json) {
        String mode;
        switch (mode = JSONUtils.func_151219_a((JsonObject)json, (String)"mode", (String)"inscribe")) {
            case "inscribe": {
                return InscriberProcessType.INSCRIBE;
            }
            case "press": {
                return InscriberProcessType.PRESS;
            }
        }
        throw new IllegalStateException("Unknown mode for inscriber recipe: " + mode);
    }

    public InscriberRecipe read(ResourceLocation recipeId, JsonObject json) {
        InscriberProcessType mode = InscriberRecipeSerializer.getMode(json);
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        JsonObject ingredients = JSONUtils.func_152754_s((JsonObject)json, (String)"ingredients");
        Ingredient middle = Ingredient.func_199802_a((JsonElement)ingredients.get("middle"));
        Ingredient top = Ingredient.field_193370_a;
        if (ingredients.has("top")) {
            top = Ingredient.func_199802_a((JsonElement)ingredients.get("top"));
        }
        Ingredient bottom = Ingredient.field_193370_a;
        if (ingredients.has("bottom")) {
            bottom = Ingredient.func_199802_a((JsonElement)ingredients.get("bottom"));
        }
        return new InscriberRecipe(recipeId, group, middle, result, top, bottom, mode);
    }

    @Nullable
    public InscriberRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_218666_n();
        Ingredient middle = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack result = buffer.func_150791_c();
        Ingredient top = Ingredient.func_199566_b((PacketBuffer)buffer);
        Ingredient bottom = Ingredient.func_199566_b((PacketBuffer)buffer);
        InscriberProcessType mode = (InscriberProcessType)buffer.func_179257_a(InscriberProcessType.class);
        return new InscriberRecipe(recipeId, group, middle, result, top, bottom, mode);
    }

    public void write(PacketBuffer buffer, InscriberRecipe recipe) {
        buffer.func_180714_a(recipe.func_193358_e());
        recipe.getMiddleInput().func_199564_a(buffer);
        buffer.func_150788_a(recipe.func_77571_b());
        recipe.getTopOptional().func_199564_a(buffer);
        recipe.getBottomOptional().func_199564_a(buffer);
        buffer.func_179249_a((Enum)recipe.getProcessType());
    }

    static {
        INSTANCE.setRegistryName("appliedenergistics2", "inscriber");
    }
}

