/*
 * Decompiled with CFR 0.152.
 */
package appeng.services;

import appeng.api.util.DimensionalCoord;
import appeng.core.Api;
import appeng.services.compass.CompassReader;
import appeng.services.compass.ICompassCallback;
import appeng.util.Platform;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class CompassService {
    private static final int CHUNK_SIZE = 16;
    private final MinecraftServer server;
    private final Map<DimensionType, CompassReader> worldSet = new HashMap<DimensionType, CompassReader>(10);
    private final ExecutorService executor;
    private int jobSize;

    public CompassService(MinecraftServer server, @Nonnull ThreadFactory factory) {
        this.server = server;
        this.executor = Executors.newSingleThreadExecutor(factory);
        this.jobSize = 0;
    }

    public Future<?> getCompassDirection(DimensionalCoord coord, int maxRange, ICompassCallback cc) {
        ++this.jobSize;
        return this.executor.submit(new CMDirectionRequest(coord, maxRange, cc));
    }

    @SubscribeEvent
    public void unloadWorld(WorldEvent.Unload event) {
        DimensionType dim = event.getWorld().func_201675_m().func_186058_p();
        if (Platform.isServer() && this.worldSet.containsKey(dim)) {
            CompassReader compassReader = this.worldSet.remove(dim);
            compassReader.close();
        }
    }

    private int jobSize() {
        return this.jobSize;
    }

    private void cleanUp() {
        for (CompassReader cr : this.worldSet.values()) {
            cr.close();
        }
    }

    public void updateArea(IWorld w, ChunkPos chunkPos) {
        this.updateArea(w, chunkPos, 16);
        this.updateArea(w, chunkPos, 48);
        this.updateArea(w, chunkPos, 80);
        this.updateArea(w, chunkPos, 112);
        this.updateArea(w, chunkPos, 144);
        this.updateArea(w, chunkPos, 176);
        this.updateArea(w, chunkPos, 208);
        this.updateArea(w, chunkPos, 240);
    }

    public Future<?> updateArea(IWorld w, ChunkPos chunkPos, int y) {
        ++this.jobSize;
        int cx = chunkPos.field_77276_a;
        int cdy = y >> 5;
        int cz = chunkPos.field_77275_b;
        int low_y = cdy << 5;
        int hi_y = low_y + 32;
        IChunk c = w.func_212866_a_(cx, cz);
        DimensionType dim = w.func_201675_m().func_186058_p();
        Block skyStoneBlock = Api.instance().definitions().blocks().skyStoneBlock().block();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int i = 0; i < 16; ++i) {
            pos.func_223471_o(i);
            for (int j = 0; j < 16; ++j) {
                pos.func_223472_q(j);
                for (int k = low_y; k < hi_y; ++k) {
                    pos.func_185336_p(k);
                    Block blk = c.func_180495_p((BlockPos)pos).func_177230_c();
                    if (blk != skyStoneBlock) continue;
                    return this.executor.submit(new CMUpdatePost(dim, cx, cz, cdy, true));
                }
            }
        }
        return this.executor.submit(new CMUpdatePost(dim, cx, cz, cdy, false));
    }

    public void kill() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(6L, TimeUnit.MINUTES);
            this.jobSize = 0;
            for (CompassReader cr : this.worldSet.values()) {
                cr.close();
            }
            this.worldSet.clear();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private CompassReader getReader(DimensionType dim) {
        CompassReader cr = this.worldSet.get(dim);
        if (cr == null) {
            ServerWorld sw = this.server.func_71218_a(dim);
            cr = new CompassReader(sw);
            this.worldSet.put(dim, cr);
        }
        return cr;
    }

    private int dist(int ax, int az, int bx, int bz) {
        int up = (bz - az) * 16;
        int side = (bx - ax) * 16;
        return up * up + side * side;
    }

    private double rad(int ax, int az, int bx, int bz) {
        int up = bz - az;
        int side = bx - ax;
        return Math.atan2(-up, side) - 1.5707963267948966;
    }

    private class CMDirectionRequest
    implements Runnable {
        public final int maxRange;
        public final DimensionalCoord coord;
        public final ICompassCallback callback;

        public CMDirectionRequest(DimensionalCoord coord, int getMaxRange, ICompassCallback cc) {
            this.coord = coord;
            this.maxRange = getMaxRange;
            this.callback = cc;
        }

        @Override
        public void run() {
            CompassService.this.jobSize--;
            int cx = this.coord.x >> 4;
            int cz = this.coord.z >> 4;
            CompassReader cr = CompassService.this.getReader(this.coord.getWorld().func_201675_m().func_186058_p());
            if (cr.hasBeacon(cx, cz)) {
                this.callback.calculatedDirection(true, true, -999.0, 0.0);
                if (CompassService.this.jobSize() < 2) {
                    CompassService.this.cleanUp();
                }
                return;
            }
            for (int offset = 1; offset < this.maxRange; ++offset) {
                int closeness;
                int minX = cx - offset;
                int minZ = cz - offset;
                int maxX = cx + offset;
                int maxZ = cz + offset;
                int closest = Integer.MAX_VALUE;
                int chosen_x = cx;
                int chosen_z = cz;
                for (int z = minZ; z <= maxZ; ++z) {
                    if (cr.hasBeacon(minX, z) && (closeness = CompassService.this.dist(cx, cz, minX, z)) < closest) {
                        closest = closeness;
                        chosen_x = minX;
                        chosen_z = z;
                    }
                    if (!cr.hasBeacon(maxX, z) || (closeness = CompassService.this.dist(cx, cz, maxX, z)) >= closest) continue;
                    closest = closeness;
                    chosen_x = maxX;
                    chosen_z = z;
                }
                for (int x = minX + 1; x < maxX; ++x) {
                    if (cr.hasBeacon(x, minZ) && (closeness = CompassService.this.dist(cx, cz, x, minZ)) < closest) {
                        closest = closeness;
                        chosen_x = x;
                        chosen_z = minZ;
                    }
                    if (!cr.hasBeacon(x, maxZ) || (closeness = CompassService.this.dist(cx, cz, x, maxZ)) >= closest) continue;
                    closest = closeness;
                    chosen_x = x;
                    chosen_z = maxZ;
                }
                if (closest >= Integer.MAX_VALUE) continue;
                this.callback.calculatedDirection(true, false, CompassService.this.rad(cx, cz, chosen_x, chosen_z), CompassService.this.dist(cx, cz, chosen_x, chosen_z));
                if (CompassService.this.jobSize() < 2) {
                    CompassService.this.cleanUp();
                }
                return;
            }
            this.callback.calculatedDirection(false, true, -999.0, 999.0);
            if (CompassService.this.jobSize() < 2) {
                CompassService.this.cleanUp();
            }
        }
    }

    private class CMUpdatePost
    implements Runnable {
        public final DimensionType dim;
        public final int chunkX;
        public final int chunkZ;
        public final int doubleChunkY;
        public final boolean value;

        public CMUpdatePost(DimensionType dim, int cx, int cz, int dcy, boolean val) {
            this.dim = dim;
            this.chunkX = cx;
            this.doubleChunkY = dcy;
            this.chunkZ = cz;
            this.value = val;
        }

        @Override
        public void run() {
            CompassService.this.jobSize--;
            CompassReader cr = CompassService.this.getReader(this.dim);
            cr.setHasBeacon(this.chunkX, this.chunkZ, this.doubleChunkY, this.value);
            if (CompassService.this.jobSize() < 2) {
                CompassService.this.cleanUp();
            }
        }
    }
}

