/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.core.AELog;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public final class SpatialDimensionExtraData {
    private static final int CURRENT_FORMAT = 1;
    private final BlockPos size;

    public SpatialDimensionExtraData(BlockPos size) {
        this.size = size;
    }

    public PacketBuffer write() {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.writeByte(1);
        buf.func_179255_a(this.size);
        buf.capacity(buf.writerIndex());
        return buf;
    }

    public BlockPos getSize() {
        return this.size;
    }

    @Nullable
    public static SpatialDimensionExtraData read(@Nullable PacketBuffer buf) {
        if (buf == null) {
            return null;
        }
        try {
            buf.readerIndex(0);
            byte version = buf.readByte();
            if (version != 1) {
                return null;
            }
            BlockPos size = buf.func_179259_c();
            return new SpatialDimensionExtraData(size);
        }
        catch (IndexOutOfBoundsException e) {
            AELog.warn(e, "Failed to read spatial storage dimension data.");
            return null;
        }
    }
}

