/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.storage.ISpatialDimension;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.spatial.SpatialDimensionExtraData;
import appeng.spatial.StorageCellDimension;
import appeng.spatial.StorageCellModDimension;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class SpatialDimensionManager
implements ISpatialDimension {
    public static final ISpatialDimension INSTANCE = new SpatialDimensionManager();
    private static final String DIM_ID_PREFIX = "spatial_";

    private SpatialDimensionManager() {
    }

    @Override
    public ServerWorld getWorld(DimensionType cellDim) {
        return DimensionManager.getWorld((MinecraftServer)SpatialDimensionManager.getServer(), (DimensionType)cellDim, (boolean)true, (boolean)true);
    }

    @Override
    public DimensionType createNewCellDimension(BlockPos size) {
        ResourceLocation dimKey = this.findFreeDimensionId();
        AELog.info("Allocating storage cell dimension '%s'", dimKey);
        PacketBuffer extraData = new SpatialDimensionExtraData(size).write();
        return DimensionManager.registerDimension((ResourceLocation)dimKey, (ModDimension)StorageCellModDimension.INSTANCE, (PacketBuffer)extraData, (boolean)true);
    }

    private ResourceLocation findFreeDimensionId() {
        int maxId = 0;
        for (DimensionType dimensionType : DimensionType.func_212681_b()) {
            String path;
            ResourceLocation regName = dimensionType.getRegistryName();
            if (regName == null || !"appliedenergistics2".equals(regName.func_110624_b()) || !(path = regName.func_110623_a()).startsWith(DIM_ID_PREFIX)) continue;
            try {
                String numericIdPart = path.substring(DIM_ID_PREFIX.length());
                maxId = Math.max(Integer.parseUnsignedInt(numericIdPart), maxId);
            }
            catch (NumberFormatException e) {
                AELog.warn("Unparsable storage cell dimension id '%s'", path, e);
            }
        }
        return new ResourceLocation("appliedenergistics2", DIM_ID_PREFIX + ++maxId);
    }

    @Override
    public void deleteCellDimension(DimensionType cellDim) {
        AELog.info("Unregistering storage cell dimension %s", cellDim.getRegistryName());
        MinecraftServer server = SpatialDimensionManager.getServer();
        ServerWorld world = DimensionManager.getWorld((MinecraftServer)server, (DimensionType)cellDim, (boolean)false, (boolean)false);
        if (world != null) {
            DimensionManager.unloadWorld((ServerWorld)world);
        }
        DimensionManager.unloadWorlds((MinecraftServer)server, (boolean)true);
        DimensionManager.unregisterDimension((int)cellDim.func_186068_a());
    }

    @Override
    public boolean isCellDimension(DimensionType cellDim) {
        if (cellDim.getRegistryName() == null || !cellDim.getRegistryName().equals((Object)DimensionType.func_212678_a((DimensionType)cellDim))) {
            return false;
        }
        return cellDim.getModType() instanceof StorageCellModDimension;
    }

    @Override
    public BlockPos getCellDimensionOrigin(DimensionType cellDim) {
        return StorageCellDimension.REGION_CENTER;
    }

    @Override
    public BlockPos getCellDimensionSize(DimensionType cellDim) {
        SpatialDimensionExtraData extraData = this.getExtraData(cellDim);
        return extraData != null ? extraData.getSize() : BlockPos.field_177992_a;
    }

    @Override
    public void addCellDimensionTooltip(DimensionType cellDim, List<ITextComponent> lines) {
        int dimId;
        ResourceLocation registryName = cellDim.getRegistryName();
        if (registryName == null || !"appliedenergistics2".equals(registryName.func_110624_b())) {
            return;
        }
        if (!registryName.func_110623_a().startsWith(DIM_ID_PREFIX)) {
            return;
        }
        BlockPos size = INSTANCE.getCellDimensionSize(cellDim);
        lines.add(GuiText.StoredSize.textComponent(size.func_177958_n(), size.func_177956_o(), size.func_177952_p()));
        try {
            String numericIdPart = registryName.func_110623_a().substring(DIM_ID_PREFIX.length());
            dimId = Integer.parseUnsignedInt(numericIdPart);
        }
        catch (NumberFormatException ignored) {
            return;
        }
        String serialNumber = String.format(Locale.ROOT, "SP-%04d", dimId);
        lines.add(GuiText.SerialNumber.textComponent(serialNumber));
    }

    @Nullable
    private SpatialDimensionExtraData getExtraData(DimensionType cellDim) {
        if (!(cellDim.getModType() instanceof StorageCellModDimension)) {
            return null;
        }
        return SpatialDimensionExtraData.read(cellDim.getData());
    }

    private static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }
}

