/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.client.render.effects.ParticleTypes;
import appeng.core.AppEng;
import appeng.tile.crafting.AssemblerAnimationStatus;
import appeng.tile.crafting.MolecularAssemblerTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
public class MolecularAssemblerRenderer
extends TileEntityRenderer<MolecularAssemblerTileEntity> {
    public static final ResourceLocation LIGHTS_MODEL = new ResourceLocation("appliedenergistics2", "block/molecular_assembler_lights");
    private static final RenderType MC_161917_RENDERTYPE_FIX = MolecularAssemblerRenderer.createRenderType();
    private final Random particleRandom = new Random();

    public MolecularAssemblerRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(MolecularAssemblerTileEntity molecularAssembler, float partialTicks, MatrixStack ms, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        AssemblerAnimationStatus status = molecularAssembler.getAnimationStatus();
        if (status != null) {
            if (!Minecraft.func_71410_x().func_147113_T()) {
                if (status.isExpired()) {
                    molecularAssembler.setAnimationStatus(null);
                }
                status.setAccumulatedTicks(status.getAccumulatedTicks() + partialTicks);
                status.setTicksUntilParticles(status.getTicksUntilParticles() - partialTicks);
            }
            this.renderStatus(molecularAssembler, ms, bufferIn, combinedLightIn, status);
        }
        if (molecularAssembler.isPowered()) {
            this.renderPowerLight(ms, bufferIn, combinedLightIn, combinedOverlayIn);
        }
    }

    private void renderPowerLight(MatrixStack ms, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Minecraft minecraft = Minecraft.func_71410_x();
        IBakedModel lightsModel = minecraft.func_209506_al().getModel(LIGHTS_MODEL);
        IVertexBuilder buffer = bufferIn.getBuffer(MC_161917_RENDERTYPE_FIX);
        minecraft.func_175602_ab().func_175019_b().renderModel(ms.func_227866_c_(), buffer, null, lightsModel, 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    private void renderStatus(MolecularAssemblerTileEntity molecularAssembler, MatrixStack ms, IRenderTypeBuffer bufferIn, int combinedLightIn, AssemblerAnimationStatus status) {
        double centerX = (float)molecularAssembler.func_174877_v().func_177958_n() + 0.5f;
        double centerY = (float)molecularAssembler.func_174877_v().func_177956_o() + 0.5f;
        double centerZ = (float)molecularAssembler.func_174877_v().func_177952_p() + 0.5f;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (status.getTicksUntilParticles() <= 0.0f) {
            status.setTicksUntilParticles(4.0f);
            if (AppEng.proxy.shouldAddParticles(this.particleRandom)) {
                for (int x = 0; x < (int)Math.ceil((double)status.getSpeed() / 5.0); ++x) {
                    minecraft.field_71452_i.func_199280_a((IParticleData)ParticleTypes.CRAFTING, centerX, centerY, centerZ, 0.0, 0.0, 0.0);
                }
            }
        }
        ItemStack is = status.getIs();
        ItemRenderer itemRenderer = minecraft.func_175599_af();
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 0.5, 0.5);
        if (!(is.func_77973_b().getItem() instanceof BlockItem)) {
            ms.func_227861_a_(0.0, (double)-0.3f, 0.0);
        } else {
            ms.func_227861_a_(0.0, (double)-0.2f, 0.0);
        }
        itemRenderer.func_229110_a_(is, ItemCameraTransforms.TransformType.GROUND, combinedLightIn, OverlayTexture.field_229196_a_, ms, bufferIn);
        ms.func_227865_b_();
    }

    private static RenderType createRenderType() {
        RenderState.TransparencyState TRANSLUCENT_TRANSPARENCY = (RenderState.TransparencyState)ObfuscationReflectionHelper.getPrivateValue(RenderState.class, null, (String)"field_228515_g_");
        RenderState.TextureState mipmapBlockAtlasTexture = new RenderState.TextureState(AtlasTexture.field_110575_b, false, true);
        RenderState.LightmapState disableLightmap = new RenderState.LightmapState(false);
        RenderType.State glState = RenderType.State.func_228694_a_().func_228724_a_(mipmapBlockAtlasTexture).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228713_a_(new RenderState.AlphaState(0.05f)).func_228719_a_(disableLightmap).func_228728_a_(true);
        return RenderType.func_228632_a_((String)"ae2_translucent_alphatest", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (RenderType.State)glState);
    }
}

