/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.util.AEColor;
import appeng.block.paint.PaintSplotches;
import appeng.helpers.Splotch;
import appeng.items.misc.PaintBallItem;
import appeng.tile.AEBaseTileEntity;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class PaintSplotchesTileEntity
extends AEBaseTileEntity {
    public static final ModelProperty<PaintSplotches> SPLOTCHES = new ModelProperty();
    private static final int LIGHT_PER_DOT = 12;
    private int isLit = 0;
    private List<Splotch> dots = null;

    public PaintSplotchesTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        PacketBuffer myDat = new PacketBuffer(Unpooled.buffer());
        this.writeBuffer(myDat);
        if (myDat.hasArray()) {
            data.func_74773_a("dots", myDat.array());
        }
        return data;
    }

    private void writeBuffer(PacketBuffer out) {
        if (this.dots == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(this.dots.size());
        for (Splotch s : this.dots) {
            s.writeToStream(out);
        }
    }

    @Override
    public void func_145839_a(CompoundNBT data) {
        super.func_145839_a(data);
        if (data.func_74764_b("dots")) {
            this.readBuffer(new PacketBuffer(Unpooled.copiedBuffer((byte[])data.func_74770_j("dots"))));
        }
    }

    private void readBuffer(PacketBuffer in) {
        int howMany = in.readByte();
        if (howMany == 0) {
            this.isLit = 0;
            this.dots = null;
            return;
        }
        this.dots = new ArrayList<Splotch>(howMany);
        for (int x = 0; x < howMany; ++x) {
            this.dots.add(new Splotch(in));
        }
        this.isLit = 0;
        for (Splotch s : this.dots) {
            if (!s.isLumen()) continue;
            this.isLit += 12;
        }
        this.maxLit();
    }

    private void maxLit() {
        if (this.isLit > 14) {
            this.isLit = 14;
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_226658_a_(LightType.BLOCK, this.field_174879_c);
        }
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        this.writeBuffer(data);
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        super.readFromStream(data);
        this.readBuffer(data);
        return true;
    }

    public void neighborChanged() {
        if (this.dots == null) {
            return;
        }
        for (Direction side : Direction.values()) {
            if (this.isSideValid(side)) continue;
            this.removeSide(side);
        }
        this.updateData();
    }

    public boolean isSideValid(Direction side) {
        BlockPos p = this.field_174879_c.func_177972_a(side);
        BlockState blk = this.field_145850_b.func_180495_p(p);
        return blk.func_224755_d((IBlockReader)this.field_145850_b, p, side.func_176734_d());
    }

    private void removeSide(Direction side) {
        Iterator<Splotch> i = this.dots.iterator();
        while (i.hasNext()) {
            Splotch s = i.next();
            if (s.getSide() != side) continue;
            i.remove();
        }
        this.markForUpdate();
        this.saveChanges();
    }

    private void updateData() {
        this.isLit = 0;
        for (Splotch s : this.dots) {
            if (!s.isLumen()) continue;
            this.isLit += 12;
        }
        this.maxLit();
        if (this.dots.isEmpty()) {
            this.dots = null;
        }
        if (this.dots == null) {
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
    }

    public void cleanSide(Direction side) {
        if (this.dots == null) {
            return;
        }
        this.removeSide(side);
        this.updateData();
    }

    public int getLightLevel() {
        return this.isLit;
    }

    public void addBlot(ItemStack type, Direction side, Vec3d hitVec) {
        BlockPos p = this.field_174879_c.func_177972_a(side);
        BlockState blk = this.field_145850_b.func_180495_p(p);
        if (blk.func_224755_d((IBlockReader)this.field_145850_b, p, side.func_176734_d())) {
            PaintBallItem ipb = (PaintBallItem)type.func_77973_b();
            AEColor col = ipb.getColor();
            boolean lit = ipb.isLumen();
            if (this.dots == null) {
                this.dots = new ArrayList<Splotch>();
            }
            if (this.dots.size() > 20) {
                this.dots.remove(0);
            }
            this.dots.add(new Splotch(col, lit, side, hitVec));
            if (lit) {
                this.isLit += 12;
            }
            this.maxLit();
            this.markForUpdate();
            this.saveChanges();
        }
    }

    public Collection<Splotch> getDots() {
        if (this.dots == null) {
            return Collections.emptyList();
        }
        return this.dots;
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(SPLOTCHES, (Object)new PaintSplotches(this.getDots())).build();
    }
}

