/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.qnb;

import appeng.api.definitions.ITileDefinition;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.block.qnb.QnbFormedState;
import appeng.core.Api;
import appeng.me.GridAccessException;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.QuantumCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.tile.grid.AENetworkInvTileEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.InvOperation;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class QuantumBridgeTileEntity
extends AENetworkInvTileEntity
implements IAEMultiBlock,
ITickableTileEntity {
    public static final ModelProperty<QnbFormedState> FORMED_STATE = new ModelProperty();
    private final byte corner = (byte)16;
    private final AppEngInternalInventory internalInventory = new AppEngInternalInventory(this, 1, 1);
    private final byte hasSingularity = (byte)32;
    private final byte powered = (byte)64;
    private final QuantumCalculator calc = new QuantumCalculator(this);
    private byte constructed = (byte)-1;
    private QuantumCluster cluster;
    private boolean updateStatus = false;

    public QuantumBridgeTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setValidSides(EnumSet.noneOf(Direction.class));
        this.getProxy().setFlags(GridFlags.DENSE_CAPACITY);
        this.getProxy().setIdlePowerUsage(22.0);
    }

    public void func_73660_a() {
        if (this.updateStatus) {
            this.updateStatus = false;
            if (this.cluster != null) {
                this.cluster.updateStatus(true);
            }
            this.markForUpdate();
        }
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        int out = this.constructed;
        if (!this.internalInventory.getStackInSlot(0).func_190926_b() && this.constructed != -1) {
            out |= this.hasSingularity;
        }
        if (this.getProxy().isActive() && this.constructed != -1) {
            out |= this.powered;
        }
        data.writeByte((int)((byte)out));
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        byte oldValue = this.constructed;
        this.constructed = data.readByte();
        return this.constructed != oldValue || c;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.cluster != null) {
            this.cluster.updateStatus(true);
        }
    }

    @Override
    protected IItemHandler getItemHandlerForSide(Direction side) {
        if (this.isCenter()) {
            return this.internalInventory;
        }
        return EmptyHandler.INSTANCE;
    }

    private boolean isCenter() {
        return Api.instance().definitions().blocks().quantumLink().maybeBlock().map(link -> this.func_195044_w().func_177230_c() == link).orElse(false);
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange c) {
        this.updateStatus = true;
    }

    @Override
    public void onChunkUnloaded() {
        this.disconnect(false);
        super.onChunkUnloaded();
    }

    @Override
    public void onReady() {
        boolean isPresent;
        super.onReady();
        ITileDefinition quantumRing = Api.instance().definitions().blocks().quantumRing();
        Optional<Block> maybeLinkBlock = quantumRing.maybeBlock();
        Optional<ItemStack> maybeLinkStack = quantumRing.maybeStack(1);
        boolean bl = isPresent = maybeLinkBlock.isPresent() && maybeLinkStack.isPresent();
        if (isPresent && this.func_195044_w().func_177230_c() == maybeLinkBlock.get()) {
            ItemStack linkStack = maybeLinkStack.get();
            this.getProxy().setVisualRepresentation(linkStack);
        }
    }

    @Override
    public void func_145843_s() {
        this.disconnect(false);
        super.func_145843_s();
    }

    @Override
    public void disconnect(boolean affectWorld) {
        if (this.cluster != null) {
            if (!affectWorld) {
                this.cluster.setUpdateStatus(false);
            }
            this.cluster.destroy();
        }
        this.cluster = null;
        if (affectWorld) {
            this.getProxy().setValidSides(EnumSet.noneOf(Direction.class));
        }
    }

    @Override
    public IAECluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return !this.func_145837_r();
    }

    public void updateStatus(QuantumCluster c, byte flags, boolean affectWorld) {
        this.cluster = c;
        if (affectWorld) {
            if (this.constructed != flags) {
                this.constructed = flags;
                this.markForUpdate();
            }
            if (this.isCorner() || this.isCenter()) {
                EnumSet<Direction> sides = EnumSet.noneOf(Direction.class);
                for (Direction dir : this.getAdjacentQuantumBridges()) {
                    sides.add(dir);
                }
                this.getProxy().setValidSides(sides);
            } else {
                this.getProxy().setValidSides(EnumSet.allOf(Direction.class));
            }
        }
    }

    public boolean isCorner() {
        return (this.constructed & this.getCorner()) == this.getCorner() && this.constructed != -1;
    }

    public EnumSet<Direction> getAdjacentQuantumBridges() {
        EnumSet<Direction> set = EnumSet.noneOf(Direction.class);
        for (Direction d : Direction.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(d));
            if (!(te instanceof QuantumBridgeTileEntity)) continue;
            set.add(d);
        }
        return set;
    }

    public long getQEFrequency() {
        CompoundNBT c;
        ItemStack is = this.internalInventory.getStackInSlot(0);
        if (!is.func_190926_b() && (c = is.func_77978_p()) != null) {
            return c.func_74763_f("freq");
        }
        return 0L;
    }

    public boolean isPowered() {
        if (this.isRemote()) {
            return (this.constructed & this.powered) == this.powered && this.constructed != -1;
        }
        try {
            return this.getProxy().getEnergy().isNetworkPowered();
        }
        catch (GridAccessException gridAccessException) {
            return false;
        }
    }

    public boolean isFormed() {
        return this.constructed != -1;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.DENSE_SMART;
    }

    public void neighborUpdate() {
        this.calc.calculateMultiblock(this.field_145850_b, this.getLocation());
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    public boolean hasQES() {
        if (this.constructed == -1) {
            return false;
        }
        return (this.constructed & this.hasSingularity) == this.hasSingularity;
    }

    public void breakCluster() {
        if (this.cluster != null) {
            this.cluster.destroy();
        }
    }

    public byte getCorner() {
        return this.corner;
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(FORMED_STATE, (Object)new QnbFormedState(this.getAdjacentQuantumBridges(), this.isCorner(), this.isPowered())).build();
    }
}

