/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.spatial;

import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.me.GridAccessException;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.SpatialPylonCalculator;
import appeng.me.cluster.implementations.SpatialPylonCluster;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.AENetworkProxyMultiblock;
import appeng.tile.grid.AENetworkTileEntity;
import java.io.IOException;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class SpatialPylonTileEntity
extends AENetworkTileEntity
implements IAEMultiBlock {
    public static final ModelProperty<Integer> STATE = new ModelProperty(value -> (value & 0xFFFFFFC0) == 0);
    public static final int DISPLAY_END_MIN = 1;
    public static final int DISPLAY_END_MAX = 2;
    public static final int DISPLAY_MIDDLE = 3;
    public static final int DISPLAY_X = 4;
    public static final int DISPLAY_Y = 8;
    public static final int DISPLAY_Z = 12;
    public static final int MB_STATUS = 15;
    public static final int DISPLAY_ENABLED = 16;
    public static final int DISPLAY_POWERED_ENABLED = 32;
    public static final int NET_STATUS = 48;
    private final SpatialPylonCalculator calc = new SpatialPylonCalculator(this);
    private int displayBits = 0;
    private SpatialPylonCluster cluster;
    private boolean didHaveLight = false;

    public SpatialPylonTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL, GridFlags.MULTIBLOCK);
        this.getProxy().setIdlePowerUsage(0.5);
        this.getProxy().setValidSides(EnumSet.noneOf(Direction.class));
    }

    @Override
    protected AENetworkProxy createProxy() {
        return new AENetworkProxyMultiblock(this, "proxy", this.getItemFromTile(this), true);
    }

    @Override
    public void onChunkUnloaded() {
        this.disconnect(false);
        super.onChunkUnloaded();
    }

    @Override
    public void onReady() {
        super.onReady();
        this.neighborChanged();
    }

    @Override
    public void func_145843_s() {
        this.disconnect(false);
        super.func_145843_s();
    }

    public void neighborChanged() {
        this.calc.calculateMultiblock(this.field_145850_b, this.getLocation());
    }

    @Override
    public void disconnect(boolean b) {
        if (this.cluster != null) {
            this.cluster.destroy();
            this.updateStatus(null);
        }
    }

    @Override
    public SpatialPylonCluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public void updateStatus(SpatialPylonCluster c) {
        this.cluster = c;
        this.getProxy().setValidSides(c == null ? EnumSet.noneOf(Direction.class) : EnumSet.allOf(Direction.class));
        this.recalculateDisplay();
    }

    public void recalculateDisplay() {
        int oldBits = this.displayBits;
        this.displayBits = 0;
        if (this.cluster != null) {
            this.displayBits = this.cluster.getMin().equals(this.getLocation()) ? 1 : (this.cluster.getMax().equals(this.getLocation()) ? 2 : 3);
            switch (this.cluster.getCurrentAxis()) {
                case X: {
                    this.displayBits |= 4;
                    break;
                }
                case Y: {
                    this.displayBits |= 8;
                    break;
                }
                case Z: {
                    this.displayBits |= 0xC;
                    break;
                }
                default: {
                    this.displayBits = 0;
                }
            }
            try {
                if (this.getProxy().getEnergy().isNetworkPowered()) {
                    this.displayBits |= 0x20;
                }
                if (this.cluster.isValid() && this.getProxy().isActive()) {
                    this.displayBits |= 0x10;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (oldBits != this.displayBits) {
            this.markForUpdate();
        }
    }

    @Override
    public void markForUpdate() {
        boolean hasLight;
        super.markForUpdate();
        boolean bl = hasLight = this.getLightValue() > 0;
        if (hasLight != this.didHaveLight) {
            this.didHaveLight = hasLight;
            this.field_145850_b.func_225524_e_().func_215568_a(this.field_174879_c);
        }
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    public int getLightValue() {
        if ((this.displayBits & 0x20) == 32) {
            return 8;
        }
        return 0;
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        int old = this.displayBits;
        this.displayBits = data.readByte();
        return old != this.displayBits || c;
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        data.writeByte(this.displayBits);
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    @MENetworkEventSubscribe
    public void activeRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    public int getDisplayBits() {
        return this.displayBits;
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(STATE, (Object)this.getDisplayBits()).build();
    }
}

