/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellGuiHandler;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import appeng.capabilities.Capabilities;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.core.Api;
import appeng.fluids.container.FluidTerminalContainer;
import appeng.fluids.util.AEFluidStack;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.helpers.MEMonitorHandler;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.grid.AENetworkPowerTileEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class ChestTileEntity
extends AENetworkPowerTileEntity
implements IMEChest,
ITerminalHost,
IPriorityHost,
IConfigManagerHost,
IColorableTile,
ITickableTileEntity {
    private static final int BIT_POWER_MASK = -128;
    private static final int BIT_STATE_MASK = 7;
    private static final int BIT_CELL_STATE_MASK = 7;
    private static final int BIT_CELL_STATE_BITS = 3;
    private final AppEngInternalInventory inputInventory = new AppEngInternalInventory(this, 1);
    private final AppEngInternalInventory cellInventory = new AppEngInternalInventory(this, 1);
    private final IItemHandler internalInventory = new WrapperChainedItemHandler(new IItemHandler[]{this.inputInventory, this.cellInventory});
    private final IActionSource mySrc = new MachineSource(this);
    private final IConfigManager config = new ConfigManager(this);
    private long lastStateChange = 0L;
    private int priority = 0;
    private int state = 0;
    private boolean wasActive = false;
    private AEColor paintedColor = AEColor.TRANSPARENT;
    private boolean isCached = false;
    private ChestMonitorHandler cellHandler;
    private Accessor accessor;
    private IFluidHandler fluidHandler;

    public ChestTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.setInternalMaxPower(PowerMultiplier.CONFIG.multiply(40.0));
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.config.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.config.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.config.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        this.setInternalPublicPowerStorage(true);
        this.setInternalPowerFlow(AccessRestriction.WRITE);
        this.inputInventory.setFilter(new InputInventoryFilter());
        this.cellInventory.setFilter(new CellInventoryFilter());
    }

    public ItemStack getCell() {
        return this.cellInventory.getStackInSlot(0);
    }

    @Override
    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
        if (x == MENetworkPowerStorage.PowerEventType.REQUEST_POWER) {
            try {
                this.getProxy().getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            this.recalculateDisplay();
        }
    }

    private void recalculateDisplay() {
        int oldState = this.state;
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.state |= this.getCellStatus(x).ordinal() << 3 * x;
        }
        this.state = this.isPowered() ? (this.state |= 0xFFFFFF80) : (this.state &= 0x7F);
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (oldState != this.state) {
            this.markForUpdate();
        }
    }

    @Override
    public int getCellCount() {
        return 1;
    }

    private void updateHandler() {
        if (!this.isCached) {
            this.cellHandler = null;
            this.accessor = null;
            this.fluidHandler = null;
            ItemStack is = this.getCell();
            if (!is.func_190926_b()) {
                this.isCached = true;
                ICellHandler cellHandler = Api.instance().registries().cell().getHandler(is);
                if (cellHandler != null) {
                    double power = 1.0;
                    for (IStorageChannel<? extends IAEStack<?>> iStorageChannel : Api.instance().storage().storageChannels()) {
                        ICellInventoryHandler<? extends IAEStack<?>> newCell = cellHandler.getCellInventory(is, this, iStorageChannel);
                        if (newCell == null) continue;
                        power += cellHandler.cellIdleDrain(is, newCell);
                        this.cellHandler = this.wrap(newCell);
                        break;
                    }
                    this.getProxy().setIdlePowerUsage(power);
                    this.accessor = new Accessor();
                    if (this.cellHandler != null && this.cellHandler.getChannel() == Api.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
                        this.fluidHandler = new FluidHandler();
                    }
                }
            }
        }
    }

    private <T extends IAEStack<T>> ChestMonitorHandler<T> wrap(IMEInventoryHandler<T> h) {
        if (h == null) {
            return null;
        }
        MEInventoryHandler<T> ih = new MEInventoryHandler<T>(h, h.getChannel());
        ih.setPriority(this.priority);
        ChestMonitorHandler g = new ChestMonitorHandler(ih);
        g.addListener(new ChestNetNotifier(h.getChannel()), g);
        return g;
    }

    @Override
    public CellState getCellStatus(int slot) {
        if (this.isRemote()) {
            return CellState.values()[this.state >> slot * 3 & 7];
        }
        this.updateHandler();
        ItemStack cell = this.getCell();
        ICellHandler ch = Api.instance().registries().cell().getHandler(cell);
        if (this.cellHandler != null && ch != null) {
            return ch.getStatusForCell(cell, this.cellHandler.getInternalHandler());
        }
        return CellState.ABSENT;
    }

    @Override
    @Nullable
    public Item getCellItem(int slot) {
        if (slot != 0) {
            return null;
        }
        ItemStack cell = this.getCell();
        return cell.func_190926_b() ? null : cell.func_77973_b();
    }

    @Override
    public boolean isPowered() {
        boolean gridPowered;
        if (this.isRemote()) {
            return (this.state & 0xFFFFFF80) == -128;
        }
        boolean bl = gridPowered = this.getAECurrentPower() > 64.0;
        if (!gridPowered) {
            try {
                gridPowered = this.getProxy().getEnergy().isNetworkPowered();
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return super.getAECurrentPower() > 1.0 || gridPowered;
    }

    @Override
    public boolean isCellBlinking(int slot) {
        return false;
    }

    @Override
    protected double extractAEPower(double amt, Actionable mode) {
        double stash = 0.0;
        try {
            IEnergyGrid eg = this.getProxy().getEnergy();
            stash = eg.extractAEPower(amt, mode, PowerMultiplier.ONE);
            if (stash >= amt) {
                return stash;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return super.extractAEPower(amt - stash, mode) + stash;
    }

    public void func_73660_a() {
        block5: {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            double idleUsage = this.getProxy().getIdlePowerUsage();
            try {
                double powerUsed;
                if (!this.getProxy().getEnergy().isNetworkPowered() && (powerUsed = this.extractAEPower(idleUsage, Actionable.MODULATE, PowerMultiplier.CONFIG)) + 0.1 >= idleUsage != (this.state & 0xFFFFFF80) > 0) {
                    this.recalculateDisplay();
                }
            }
            catch (GridAccessException e) {
                double powerUsed = this.extractAEPower(this.getProxy().getIdlePowerUsage(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (powerUsed + 0.1 >= idleUsage == (this.state & 0xFFFFFF80) > 0) break block5;
                this.recalculateDisplay();
            }
        }
        if (!ItemHandlerUtil.isEmpty((IItemHandler)this.inputInventory)) {
            this.tryToStoreContents();
        }
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        this.state = 0;
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.state |= this.getCellStatus(x).ordinal() << 3 * x;
        }
        this.state = this.isPowered() ? (this.state |= 0xFFFFFF80) : (this.state &= 0x7F);
        data.writeByte(this.state);
        data.writeByte(this.paintedColor.ordinal());
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        int oldState = this.state;
        this.state = data.readByte();
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        this.lastStateChange = this.field_145850_b.func_82737_E();
        return oldPaintedColor != this.paintedColor || (this.state & 0xDB6DB6DB) != (oldState & 0xDB6DB6DB) || c;
    }

    @Override
    public void func_145839_a(CompoundNBT data) {
        super.func_145839_a(data);
        this.config.readFromNBT(data);
        this.priority = data.func_74762_e("priority");
        if (data.func_74764_b("paintedColor")) {
            this.paintedColor = AEColor.values()[data.func_74771_c("paintedColor")];
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        this.config.writeToNBT(data);
        data.func_74768_a("priority", this.priority);
        data.func_74774_a("paintedColor", (byte)this.paintedColor.ordinal());
        return data;
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    @Override
    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        this.updateHandler();
        if (this.cellHandler != null && this.cellHandler.getChannel() == channel) {
            return this.cellHandler;
        }
        return null;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (inv == this.cellInventory) {
            this.cellHandler = null;
            this.isCached = false;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
                IStorageGrid gs = this.getProxy().getStorage();
                Platform.postChanges(gs, removed, added, this.mySrc);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            if (this.field_145850_b != null) {
                Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_174879_c);
                this.markForUpdate();
            }
        }
        if (inv == this.inputInventory && mc == InvOperation.INSERT) {
            this.tryToStoreContents();
        }
    }

    @Override
    protected IItemHandler getItemHandlerForSide(@Nonnull Direction side) {
        if (side == this.getForward()) {
            return this.cellInventory;
        }
        return this.inputInventory;
    }

    private void tryToStoreContents() {
        if (!ItemHandlerUtil.isEmpty((IItemHandler)this.inputInventory)) {
            this.updateHandler();
            if (this.cellHandler != null && this.cellHandler.getChannel() == Api.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
                IAEItemStack returns = Platform.poweredInsert(this, this.cellHandler, AEItemStack.fromItemStack(this.inputInventory.getStackInSlot(0)), this.mySrc);
                if (returns == null) {
                    this.inputInventory.setStackInSlot(0, ItemStack.field_190927_a);
                } else {
                    this.inputInventory.setStackInSlot(0, returns.createItemStack());
                }
            }
        }
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (this.getProxy().isActive()) {
            this.updateHandler();
            if (this.cellHandler != null && this.cellHandler.getChannel() == channel) {
                return Collections.singletonList(this.cellHandler);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.cellHandler = null;
        this.isCached = false;
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void blinkCell(int slot) {
        long now = this.field_145850_b.func_82737_E();
        if (now - this.lastStateChange > 8L) {
            this.state = 0;
        }
        this.lastStateChange = now;
        this.state |= 1 << slot * 3 + 2;
        this.recalculateDisplay();
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
    }

    public boolean openGui(PlayerEntity p) {
        ICellGuiHandler chg;
        ICellHandler ch;
        this.updateHandler();
        if (this.cellHandler != null && (ch = Api.instance().registries().cell().getHandler(this.getCell())) != null && (chg = Api.instance().registries().cell().getGuiHandler(this.cellHandler.getChannel(), this.getCell())) != null) {
            chg.openChestGui(p, this, ch, this.cellHandler, this.getCell(), this.cellHandler.getChannel());
            return true;
        }
        return false;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(Direction side, AEColor newPaintedColor, PlayerEntity who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    @Override
    public void saveChanges(ICellInventory<?> cellInventory) {
        if (cellInventory != null) {
            cellInventory.persist();
        }
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        this.updateHandler();
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.fluidHandler != null && facing != this.getForward()) {
            return LazyOptional.of(() -> this.fluidHandler);
        }
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR && this.accessor != null && facing != this.getForward()) {
            return LazyOptional.of(() -> this.accessor);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ItemStack getItemStackRepresentation() {
        return Api.instance().definitions().blocks().chest().maybeStack(1).orElse(ItemStack.field_190927_a);
    }

    @Override
    public ContainerType<?> getContainerType() {
        this.updateHandler();
        if (this.cellHandler != null) {
            if (this.cellHandler.getChannel() == Api.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
                return MEMonitorableContainer.TYPE;
            }
            if (this.cellHandler.getChannel() == Api.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
                return FluidTerminalContainer.TYPE;
            }
        }
        return null;
    }

    private static class CellInventoryFilter
    implements IAEItemFilter {
        private CellInventoryFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            return Api.instance().registries().cell().getHandler(stack) != null;
        }
    }

    private class InputInventoryFilter
    implements IAEItemFilter {
        private InputInventoryFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return false;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            if (ChestTileEntity.this.isPowered()) {
                ChestTileEntity.this.updateHandler();
                return ChestTileEntity.this.cellHandler != null && ChestTileEntity.this.cellHandler.getChannel() == Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
            }
            return false;
        }
    }

    private class FluidHandler
    implements IFluidHandler,
    IFluidTank {
        private FluidHandler() {
        }

        private boolean canAcceptLiquids() {
            return ChestTileEntity.this.cellHandler != null && ChestTileEntity.this.cellHandler.getChannel() == Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
        }

        @Nonnull
        public FluidStack getFluid() {
            return FluidStack.EMPTY;
        }

        public int getFluidAmount() {
            return 0;
        }

        public int getCapacity() {
            return this.canAcceptLiquids() ? 1000 : 0;
        }

        public boolean isFluidValid(FluidStack stack) {
            return this.canAcceptLiquids();
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? 1000 : 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            ChestTileEntity.this.updateHandler();
            if (this.canAcceptLiquids()) {
                IAEFluidStack results = Platform.poweredInsert(ChestTileEntity.this, ChestTileEntity.this.cellHandler, AEFluidStack.fromFluidStack(resource), ChestTileEntity.this.mySrc, action == IFluidHandler.FluidAction.EXECUTE ? Actionable.MODULATE : Actionable.SIMULATE);
                if (results == null) {
                    return resource.getAmount();
                }
                return resource.getAmount() - (int)results.getStackSize();
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }

    private class Accessor
    implements IStorageMonitorableAccessor {
        private Accessor() {
        }

        @Override
        @Nullable
        public IStorageMonitorable getInventory(IActionSource src) {
            if (Platform.canAccess(ChestTileEntity.this.getProxy(), src)) {
                return ChestTileEntity.this;
            }
            return null;
        }
    }

    private class ChestMonitorHandler<T extends IAEStack<T>>
    extends MEMonitorHandler<T> {
        public ChestMonitorHandler(IMEInventoryHandler<T> t) {
            super(t);
        }

        private ICellInventoryHandler<T> getInternalHandler() {
            IMEInventoryHandler h = this.getHandler();
            if (h instanceof MEInventoryHandler) {
                return (ICellInventoryHandler)((MEInventoryHandler)h).getInternal();
            }
            return (ICellInventoryHandler)this.getHandler();
        }

        @Override
        public T injectItems(T input, Actionable mode, IActionSource src) {
            if (src.player().map(player -> !this.securityCheck((PlayerEntity)player, SecurityPermissions.INJECT)).orElse(false).booleanValue()) {
                return input;
            }
            return super.injectItems(input, mode, src);
        }

        private boolean securityCheck(PlayerEntity player, SecurityPermissions requiredPermission) {
            if (ChestTileEntity.this.getTile() instanceof IActionHost && requiredPermission != null) {
                IGrid g;
                IGridNode gn = ((IActionHost)ChestTileEntity.this.getTile()).getActionableNode();
                if (gn != null && (g = gn.getGrid()) != null) {
                    boolean requirePower = false;
                    ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
                    if (sg.hasPermission(player, requiredPermission)) {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public T extractItems(T request, Actionable mode, IActionSource src) {
            if (src.player().map(player -> !this.securityCheck((PlayerEntity)player, SecurityPermissions.EXTRACT)).orElse(false).booleanValue()) {
                return null;
            }
            return super.extractItems(request, mode, src);
        }
    }

    private class ChestNetNotifier<T extends IAEStack<T>>
    implements IMEMonitorHandlerReceiver<T> {
        private final IStorageChannel<T> chan;

        public ChestNetNotifier(IStorageChannel<T> chan) {
            this.chan = chan;
        }

        @Override
        public boolean isValid(Object verificationToken) {
            ChestTileEntity.this.updateHandler();
            if (ChestTileEntity.this.cellHandler != null && this.chan == ChestTileEntity.this.cellHandler.getChannel()) {
                return verificationToken == ChestTileEntity.this.cellHandler;
            }
            return false;
        }

        @Override
        public void postChange(IBaseMonitor<T> monitor, Iterable<T> change, IActionSource source) {
            if (source == ChestTileEntity.this.mySrc || source.machine().map(machine -> machine == ChestTileEntity.this).orElse(false).booleanValue()) {
                try {
                    if (ChestTileEntity.this.getProxy().isActive()) {
                        ChestTileEntity.this.getProxy().getStorage().postAlterationOfStoredItems(this.chan, change, ChestTileEntity.this.mySrc);
                    }
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
            ChestTileEntity.this.blinkCell(0);
        }

        @Override
        public void onListUpdate() {
        }
    }
}

