/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.block.storage.DriveSlotsState;
import appeng.client.render.model.DriveModelData;
import appeng.container.implementations.DriveContainer;
import appeng.core.Api;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.DriveWatcher;
import appeng.tile.grid.AENetworkInvTileEntity;
import appeng.tile.inventory.AppEngCellInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class DriveTileEntity
extends AENetworkInvTileEntity
implements IChestOrDrive,
IPriorityHost {
    private static final int BIT_POWER_MASK = Integer.MIN_VALUE;
    private static final int BIT_STATE_MASK = 0x3FFFFFFF;
    private static final int BIT_CELL_STATE_MASK = 7;
    private static final int BIT_CELL_STATE_BITS = 3;
    private final AppEngCellInventory inv = new AppEngCellInventory(this, 10);
    private final ICellHandler[] handlersBySlot = new ICellHandler[10];
    private final DriveWatcher<IAEItemStack>[] invBySlot = new DriveWatcher[10];
    private final IActionSource mySrc;
    private boolean isCached = false;
    private Map<IStorageChannel<? extends IAEStack<?>>, List<IMEInventoryHandler>> inventoryHandlers;
    private int priority = 0;
    private boolean wasActive = false;
    private final Item[] cellItems = new Item[10];
    private int state = 0;

    public DriveTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.mySrc = new MachineSource(this);
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.inv.setFilter(new CellValidInventoryFilter());
        this.inventoryHandlers = new IdentityHashMap();
    }

    @Override
    public void setOrientation(Direction inForward, Direction inUp) {
        super.setOrientation(inForward, inUp);
        this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(inForward)));
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        int newState = 0;
        if (this.getProxy().isActive()) {
            newState |= Integer.MIN_VALUE;
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            int o = this.getCellStatus(x).ordinal();
            int i = o << 3 * x;
            newState |= i;
        }
        data.writeInt(newState);
        this.writeCellItemIds(data);
    }

    private void writeCellItemIds(PacketBuffer data) {
        ArrayList<ResourceLocation> cellItemIds = new ArrayList<ResourceLocation>(this.getCellCount());
        byte[] bm = new byte[this.getCellCount()];
        for (int x = 0; x < this.getCellCount(); ++x) {
            Item item = this.getCellItem(x);
            if (item == null || item.getRegistryName() == null) continue;
            ResourceLocation itemId = item.getRegistryName();
            int idx = cellItemIds.indexOf(itemId);
            if (idx == -1) {
                cellItemIds.add(itemId);
                bm[x] = (byte)cellItemIds.size();
                continue;
            }
            bm[x] = (byte)(1 + idx);
        }
        data.writeByte(cellItemIds.size());
        for (ResourceLocation itemId : cellItemIds) {
            data.func_192572_a(itemId);
        }
        for (int i = 0; i < this.getCellCount(); ++i) {
            data.writeByte((int)bm[i]);
        }
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        int oldState = this.state;
        this.state = data.readInt();
        return (this.state & 0x3FFFFFFF) != (oldState & 0x3FFFFFFF) || (c |= this.readCellItemIDs(data));
    }

    private boolean readCellItemIDs(PacketBuffer data) {
        int uniqueStrCount = data.readByte();
        String[] uniqueStrs = new String[uniqueStrCount];
        for (int i = 0; i < uniqueStrCount; ++i) {
            uniqueStrs[i] = data.func_218666_n();
        }
        boolean changed = false;
        for (int i = 0; i < this.getCellCount(); ++i) {
            byte idx = data.readByte();
            Item item = null;
            if (idx > 0) {
                idx = (byte)(idx - 1);
                String itemId = uniqueStrs[idx];
                item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
            }
            if (this.cellItems[i] == item) continue;
            changed = true;
            this.cellItems[i] = item;
        }
        return changed;
    }

    @Override
    public int getCellCount() {
        return 10;
    }

    @Override
    @Nullable
    public Item getCellItem(int slot) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return this.cellItems[slot];
        }
        ItemStack stackInSlot = this.inv.getStackInSlot(slot);
        if (!stackInSlot.func_190926_b()) {
            return stackInSlot.func_77973_b();
        }
        return null;
    }

    @Override
    public CellState getCellStatus(int slot) {
        if (Platform.isClient()) {
            int cellState = this.state >> slot * 3 & 7;
            return CellState.values()[cellState];
        }
        DriveWatcher<IAEItemStack> handler = this.invBySlot[slot];
        if (handler == null) {
            return CellState.ABSENT;
        }
        return handler.getStatus();
    }

    @Override
    public boolean isPowered() {
        if (this.isRemote()) {
            return (this.state & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        }
        return this.getProxy().isActive();
    }

    @Override
    public boolean isCellBlinking(int slot) {
        return false;
    }

    @Override
    public void func_145839_a(CompoundNBT data) {
        super.func_145839_a(data);
        this.isCached = false;
        this.priority = data.func_74762_e("priority");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        data.func_74768_a("priority", this.priority);
        return data;
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    private void recalculateDisplay() {
        boolean currentActive = this.getProxy().isActive();
        int newState = 0;
        if (currentActive) {
            newState |= Integer.MIN_VALUE;
        }
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            newState |= this.getCellStatus(x).ordinal() << 3 * x;
        }
        if (newState != this.state) {
            this.state = newState;
            this.markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            IStorageGrid gs = this.getProxy().getStorage();
            Platform.postChanges(gs, removed, added, this.mySrc);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.markForUpdate();
    }

    private void updateState() {
        if (!this.isCached) {
            Collection<IStorageChannel<IAEStack<?>>> storageChannels = Api.instance().storage().storageChannels();
            storageChannels.forEach(channel -> {
                List cfr_ignored_0 = this.inventoryHandlers.put((IStorageChannel<IAEStack<?>>)channel, new ArrayList(10));
            });
            double power = 2.0;
            block0: for (int x = 0; x < this.inv.getSlots(); ++x) {
                ItemStack is = this.inv.getStackInSlot(x);
                this.invBySlot[x] = null;
                this.handlersBySlot[x] = null;
                if (is.func_190926_b()) continue;
                this.handlersBySlot[x] = Api.instance().registries().cell().getHandler(is);
                if (this.handlersBySlot[x] == null) continue;
                for (IStorageChannel<? extends IAEStack<?>> iStorageChannel : storageChannels) {
                    ICellInventoryHandler<? extends IAEStack<?>> cell = this.handlersBySlot[x].getCellInventory(is, this, iStorageChannel);
                    if (cell == null) continue;
                    this.inv.setHandler(x, cell);
                    power += this.handlersBySlot[x].cellIdleDrain(is, cell);
                    DriveWatcher ih = new DriveWatcher(cell, is, this.handlersBySlot[x], this);
                    ih.setPriority(this.priority);
                    this.invBySlot[x] = ih;
                    this.inventoryHandlers.get(iStorageChannel).add(ih);
                    continue block0;
                }
            }
            this.getProxy().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    @Override
    public void onReady() {
        super.onReady();
        this.updateState();
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (this.getProxy().isActive()) {
            this.updateState();
            return this.inventoryHandlers.get(channel);
        }
        return Collections.emptyList();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.saveChanges();
        this.isCached = false;
        this.updateState();
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void blinkCell(int slot) {
        this.recalculateDisplay();
    }

    @Override
    public void saveChanges(ICellInventory<?> cellInventory) {
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    @Override
    public ItemStack getItemStackRepresentation() {
        return Api.instance().definitions().blocks().drive().maybeStack(1).orElse(ItemStack.field_190927_a);
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new DriveModelData(this.getUp(), this.getForward(), DriveSlotsState.fromChestOrDrive(this));
    }

    @Override
    public ContainerType<?> getContainerType() {
        return DriveContainer.TYPE;
    }

    private class CellValidInventoryFilter
    implements IAEItemFilter {
        private CellValidInventoryFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            return !stack.func_190926_b() && Api.instance().registries().cell().isCellHandled(stack);
        }
    }
}

