/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

final class AESharedItemStack
implements Comparable<AESharedItemStack> {
    private final ItemStack itemStack;
    private final int itemId;
    private final int itemDamage;
    private final int hashCode;

    public AESharedItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.itemId = Item.func_150891_b((Item)itemStack.func_77973_b());
        this.itemDamage = itemStack.func_77952_i();
        this.hashCode = this.makeHashCode();
    }

    Bounds getBounds(FuzzyMode fuzzy) {
        return new Bounds(this.itemStack, fuzzy);
    }

    ItemStack getDefinition() {
        return this.itemStack;
    }

    int getItemDamage() {
        return this.itemDamage;
    }

    int getItemID() {
        return this.itemId;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AESharedItemStack) {
            AESharedItemStack other = (AESharedItemStack)obj;
            Preconditions.checkState((this.itemStack.func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
            Preconditions.checkArgument((other.getDefinition().func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
            if (this.itemStack == other.itemStack) {
                return true;
            }
            return ItemStack.func_77989_b((ItemStack)this.itemStack, (ItemStack)other.itemStack);
        }
        return false;
    }

    @Override
    public int compareTo(AESharedItemStack b) {
        Preconditions.checkState((this.itemStack.func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
        Preconditions.checkArgument((b.getDefinition().func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
        if (this.itemStack == b.getDefinition()) {
            return 0;
        }
        int id = this.itemId - b.itemId;
        if (id != 0) {
            return id;
        }
        int damageValue = this.itemDamage - b.itemDamage;
        if (damageValue != 0) {
            return damageValue;
        }
        return 0;
    }

    private int makeHashCode() {
        return Objects.hash(this.itemId, this.itemDamage, this.itemStack.func_77942_o() ? this.itemStack.func_77978_p() : Integer.valueOf(0));
    }

    public static final class Bounds {
        private static final int MIN_DAMAGE_VALUE = 0;
        private static final int MAX_DAMAGE_VALUE = Short.MAX_VALUE;
        private final AESharedItemStack lower;
        private final AESharedItemStack upper;

        public Bounds(ItemStack stack, FuzzyMode fuzzy) {
            Preconditions.checkState((!stack.func_190926_b() ? 1 : 0) != 0, (Object)"ItemStack#isEmpty() has to be false");
            Preconditions.checkState((stack.func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
            CompoundNBT tag = stack.func_77942_o() ? stack.func_77978_p() : null;
            this.lower = this.makeLowerBound(stack, tag, fuzzy);
            this.upper = this.makeUpperBound(stack, tag, fuzzy);
        }

        public AESharedItemStack lower() {
            return this.lower;
        }

        public AESharedItemStack upper() {
            return this.upper;
        }

        private AESharedItemStack makeLowerBound(ItemStack itemStack, CompoundNBT tag, FuzzyMode fuzzy) {
            ItemStack newDef = itemStack.func_77946_l();
            if (newDef.func_77973_b().func_77645_m()) {
                if (fuzzy == FuzzyMode.IGNORE_ALL) {
                    newDef.func_196085_b(0);
                } else if (fuzzy == FuzzyMode.PERCENT_99) {
                    if (itemStack.func_77952_i() == 0) {
                        newDef.func_196085_b(0);
                    } else {
                        newDef.func_196085_b(1);
                    }
                } else {
                    int breakpoint = fuzzy.calculateBreakPoint(itemStack.func_77958_k());
                    int damage = breakpoint <= itemStack.func_77952_i() ? breakpoint : 0;
                    newDef.func_196085_b(damage);
                }
            }
            return new AESharedItemStack(newDef);
        }

        private AESharedItemStack makeUpperBound(ItemStack itemStack, CompoundNBT tag, FuzzyMode fuzzy) {
            ItemStack newDef = itemStack.func_77946_l();
            if (newDef.func_77973_b().func_77645_m()) {
                if (fuzzy == FuzzyMode.IGNORE_ALL) {
                    newDef.func_196085_b(itemStack.func_77958_k() + 1);
                } else if (fuzzy == FuzzyMode.PERCENT_99) {
                    if (itemStack.func_77952_i() == 0) {
                        newDef.func_196085_b(0);
                    } else {
                        newDef.func_196085_b(itemStack.func_77958_k() + 1);
                    }
                } else {
                    int breakpoint = fuzzy.calculateBreakPoint(itemStack.func_77958_k());
                    int damage = itemStack.func_77952_i() < breakpoint ? breakpoint - 1 : itemStack.func_77958_k() + 1;
                    newDef.func_196085_b(damage);
                }
            }
            return new AESharedItemStack(newDef);
        }
    }
}

