/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class MeteoriteSpawnData {
    private static final String NAME = "ae2_meteorite_spawns";
    private final SavedData data;

    private MeteoriteSpawnData(SavedData data) {
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenerated(ChunkPos chunkPos) {
        SavedData savedData = this.data;
        synchronized (savedData) {
            this.data.generated.add(chunkPos.func_201841_a());
            this.data.func_76185_a();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGenerated(ChunkPos pos) {
        SavedData savedData = this.data;
        synchronized (savedData) {
            return this.data.generated.contains(pos.func_201841_a());
        }
    }

    @Nullable
    private CompoundNBT getSpawnData(int chunkX, int chunkZ, boolean create) {
        String key = (chunkX /= 16) + "," + (chunkZ /= 16);
        INBT inbt = this.data.spawns.func_74781_a(key);
        if (!(inbt instanceof CompoundNBT)) {
            if (create) {
                inbt = new CompoundNBT();
                this.data.spawns.func_218657_a(key, inbt);
                this.data.func_76185_a();
            } else {
                return null;
            }
        }
        return (CompoundNBT)inbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMeteoriteSpawnInRange(BlockPos pos, int rangeSquared) {
        SavedData savedData = this.data;
        synchronized (savedData) {
            ChunkPos chunkPos = new ChunkPos(pos);
            CompoundNBT spawnData = this.getSpawnData(chunkPos.field_77276_a, chunkPos.field_77275_b, false);
            if (spawnData == null) {
                return false;
            }
            int size = spawnData.func_74762_e("num");
            for (int i = 0; i < size; ++i) {
                int deltaZ;
                CompoundNBT existingSettingsNbt = spawnData.func_74775_l(String.valueOf(i));
                BlockPos existingPos = PlacedMeteoriteSettings.read(existingSettingsNbt).getPos();
                int deltaX = existingPos.func_177958_n() - pos.func_177958_n();
                if (deltaX * deltaX + (deltaZ = existingPos.func_177952_p() - pos.func_177952_p()) * deltaZ > rangeSquared) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAddSpawnedMeteorite(PlacedMeteoriteSettings settings, int minDistanceSquared) {
        SavedData savedData = this.data;
        synchronized (savedData) {
            if (this.isMeteoriteSpawnInRange(settings.getPos(), minDistanceSquared)) {
                return false;
            }
            this.addSpawnedMeteorite(settings);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpawnedMeteorite(PlacedMeteoriteSettings settings) {
        SavedData savedData = this.data;
        synchronized (savedData) {
            ChunkPos chunkPos = new ChunkPos(settings.getPos());
            CompoundNBT spawnData = this.getSpawnData(chunkPos.field_77276_a, chunkPos.field_77275_b, true);
            int size = spawnData.func_74762_e("num");
            spawnData.func_218657_a(String.valueOf(size), (INBT)settings.write(new CompoundNBT()));
            spawnData.func_74768_a("num", size + 1);
            this.data.func_76185_a();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PlacedMeteoriteSettings> getNearByMeteorites(int chunkX, int chunkZ) {
        ArrayList<PlacedMeteoriteSettings> ll = new ArrayList<PlacedMeteoriteSettings>();
        SavedData savedData = this.data;
        synchronized (savedData) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    int cx = x + (chunkX >> 4);
                    int cz = z + (chunkZ >> 4);
                    CompoundNBT data = this.getSpawnData(cx << 4, cz << 4, false);
                    if (data == null) continue;
                    int size = data.func_74762_e("num");
                    for (int s = 0; s < size; ++s) {
                        CompoundNBT settingsNbt = data.func_74775_l(String.valueOf(s));
                        ll.add(PlacedMeteoriteSettings.read(settingsNbt));
                    }
                }
            }
        }
        return ll;
    }

    public static synchronized MeteoriteSpawnData get(IWorld world) {
        ServerWorld serverWorld;
        if (world instanceof ServerWorld) {
            serverWorld = (ServerWorld)world;
        } else {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            serverWorld = server.func_71218_a(world.func_201675_m().func_186058_p());
        }
        SavedData savedData = (SavedData)serverWorld.func_217481_x().func_215752_a(SavedData::new, NAME);
        return new MeteoriteSpawnData(savedData);
    }

    private static class SavedData
    extends WorldSavedData {
        private LongOpenHashSet generated = new LongOpenHashSet();
        private CompoundNBT spawns = new CompoundNBT();

        public SavedData() {
            super(MeteoriteSpawnData.NAME);
        }

        public synchronized void func_76184_a(CompoundNBT nbt) {
            this.generated = new LongOpenHashSet(nbt.func_197645_o("generated"));
            this.spawns = nbt.func_74775_l("spawns");
        }

        public synchronized CompoundNBT func_189551_b(CompoundNBT compound) {
            compound.func_197644_a("generated", this.generated.toLongArray());
            compound.func_218657_a("spawns", (INBT)this.spawns);
            return compound;
        }
    }
}

