/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.core.AELog;
import appeng.worldgen.meteorite.MeteoriteStructureStart;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.EndChunkGenerator;
import net.minecraft.world.gen.NetherChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.ScatteredStructure;
import net.minecraft.world.gen.feature.structure.Structure;

public class MeteoriteStructure
extends ScatteredStructure<NoFeatureConfig> {
    public static final Structure<NoFeatureConfig> INSTANCE = new MeteoriteStructure(NoFeatureConfig::func_214639_a);

    public MeteoriteStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean func_225558_a_(BiomeManager biomeManagerIn, ChunkGenerator<?> generator, Random randIn, int chunkX, int chunkZ, Biome biomeIn) {
        if (super.func_225558_a_(biomeManagerIn, generator, randIn, chunkX, chunkZ, biomeIn)) {
            if (generator.getClass().equals(EndChunkGenerator.class) || generator.getClass().equals(NetherChunkGenerator.class)) {
                AELog.warn("ignoring attempt to generate meteorite in nether/end.", new Object[0]);
                return false;
            }
            int i = chunkX >> 4;
            int j = chunkZ >> 4;
            randIn.setSeed((long)(i ^ j << 4) ^ generator.func_202089_c());
            randIn.nextInt();
            return randIn.nextBoolean();
        }
        return false;
    }

    public String func_143025_a() {
        return INSTANCE.getRegistryName().toString();
    }

    public int func_202367_b() {
        return 2;
    }

    public Structure.IStartFactory func_214557_a() {
        return MeteoriteStructureStart::new;
    }

    protected int func_202382_c() {
        return 124895654;
    }

    static {
        INSTANCE.setRegistryName("appliedenergistics2", "meteorite");
    }
}

