/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.core.worlddata.WorldData;
import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoritePlacer;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MeteoriteStructurePiece
extends StructurePiece {
    public static final IStructurePieceType TYPE = IStructurePieceType.func_214750_a(MeteoriteStructurePiece::new, (String)"AE2MTRT");
    private PlacedMeteoriteSettings settings;

    protected MeteoriteStructurePiece(BlockPos center, float coreRadius, CraterType craterType, FalloutMode fallout, boolean pureCrater, boolean craterLake) {
        super(TYPE, 0);
        this.settings = new PlacedMeteoriteSettings(center, coreRadius, craterType, fallout, pureCrater, craterLake);
        int range = 64;
        ChunkPos chunkPos = new ChunkPos(center);
        this.field_74887_e = new MutableBoundingBox(chunkPos.func_180334_c() - range, center.func_177956_o(), chunkPos.func_180333_d() - range, chunkPos.func_180332_e() + range, center.func_177956_o(), chunkPos.func_180330_f() + range);
    }

    public MeteoriteStructurePiece(TemplateManager templateManager, CompoundNBT tag) {
        super(TYPE, tag);
        BlockPos center = BlockPos.func_218283_e((long)tag.func_74763_f("c"));
        float coreRadius = tag.func_74760_g("r");
        CraterType craterType = CraterType.values()[tag.func_74771_c("t")];
        FalloutMode fallout = FalloutMode.values()[tag.func_74771_c("f")];
        boolean pureCrater = tag.func_74767_n("p");
        boolean craterLake = tag.func_74767_n("l");
        this.settings = new PlacedMeteoriteSettings(center, coreRadius, craterType, fallout, pureCrater, craterLake);
    }

    public boolean isFinalized() {
        return this.settings.getCraterType() != null;
    }

    public PlacedMeteoriteSettings getSettings() {
        return this.settings;
    }

    protected void func_143011_b(CompoundNBT tag) {
        tag.func_74776_a("r", this.settings.getMeteoriteRadius());
        tag.func_74772_a("c", this.settings.getPos().func_218275_a());
        tag.func_74774_a("t", (byte)this.settings.getCraterType().ordinal());
        tag.func_74774_a("f", (byte)this.settings.getFallout().ordinal());
        tag.func_74757_a("p", this.settings.isPureCrater());
        tag.func_74757_a("l", this.settings.isCraterLake());
    }

    public boolean func_225577_a_(IWorld world, ChunkGenerator<?> chunkGeneratorIn, Random rand, MutableBoundingBox bounds, ChunkPos chunkPos) {
        MeteoritePlacer placer = new MeteoritePlacer(world, this.settings, bounds);
        placer.place();
        WorldData.instance().compassData().service().updateArea(world, chunkPos);
        return true;
    }
}

